<?php
 
namespace App\Exports;
 
use DB;

use App\Http\Controllers\PenjualanController;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\BeforeExport;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class DataSaleExport implements FromCollection, WithHeadings
{
    protected  $tgl1, $opt;

    function __construct($tgl1, $opt) {
        
        $this->tgl1 = $tgl1;
        $this->opt  = $opt;
    }
    
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        
        $data = PenjualanController::getdata_sale($this->tgl1, $this->opt);
        return $data;
        
    }
    
    
	/* header di excel */
    public function headings(): array
    {
        return ["id_sale","sale_id","brg_id","type_brg","brg_nama","harga_retail","qty","isi","potongan","inv_id","sale_posted","user_id","created_at","updated_at"];
    }    

    
}


