<?php
 
namespace App\Exports;
 
use DB;

use App\Http\Controllers\ReportController;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\BeforeExport;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class KasMasukExport implements FromCollection, WithHeadings, WithCustomStartCell, ShouldAutoSize, WithTitle, WithEvents, WithColumnWidths,WithStyles
{
    protected  $tgl1, $tgl2, $prj;

    function __construct($tgl1, $tgl2, $prj) {
        
        $this->tgl1     = $tgl1;
        $this->tgl2     = $tgl2;
        $this->prj      = $prj;

    }
    
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        
        $data = ReportController::getReportMasuk($this->tgl1, $this->tgl2, $this->prj);
        return $data;
        
    }
    
    
    public function startCell(): string
    {
        return 'A1';
    }
    
	/* header di excel */
    public function headings(): array
    {
        return 
        [['Report Penjualan '.tanggal_indonesia($this->tgl1, false).' s/d '.tanggal_indonesia($this->tgl2, false)],
        ["PROJECT","CLUSTER","BLOCK","NO","CUSTOMER","NO.KWT","TANGGAL","NOMINAL","PEMBAYARAN"]];
    }    


    public function title(): string
    {
    	return 'Report Penjualan Rumah';
    }
    
    public function columnWidths(): array
    {
        return [
            'A' => 20,
            'B' => 10,    
            'C' => 8,
            'D' => 8,
            'E' => 50,
            'F' => 20,
            'G' => 15,
            'H' => 15,
            'I' => 15
 
        ];
    }
    
    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            'A1'    => ['font' => ['bold' => true, 'size' => 14]],

            // Styling a specific cell by coordinate.
            //'B2' => ['font' => ['italic' => true]],

            // Styling an entire column.
            //'A1'  => ['font' => ['size' => 14]],
        ];
    }    
    
    public function registerEvents(): array
    {
        return [

            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->getDelegate()->getStyle('A2:I2')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('FF00FF00');
              
                 $event->sheet->getDelegate()->freezePane('A3');  
            },

        ];
    }        
    
}


