<?php
 
namespace App\Exports;
 
use DB;

use App\Http\Controllers\ReportController;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\BeforeExport;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class PiutangExport implements FromCollection, WithHeadings, WithCustomStartCell, ShouldAutoSize, WithTitle, WithEvents, WithColumnWidths,WithStyles, WithColumnFormatting
{
    protected  $gdg;

    function __construct($gdg) {
        
        $this->gdg  = $gdg;
        
    }
    
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        
        $data = ReportController::getReportPiutang($this->gdg);
        return $data;
        
    }
    
    
    public function startCell(): string
    {
        return 'A1';
    }
    
	/* header di excel */
    public function headings(): array
    {
        return [['Report Sisa Piutang'],
        ["GDG","CUSTOMER","No.Invoice","Tgl.Inv","Tgl.JT","TOTAL"]];
    }    


    public function title(): string
    {
    	return 'Report Sisa Piutang';
    }
    
    public function columnWidths(): array
    {
        return [
            'A' => 8,
            'B' => 50,    
            'C' => 15,
            'D' => 15,
            'E' => 15,
            'F' => 15,

        ];
    }
    
    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            'A1'    => ['font' => ['bold' => true, 'size' => 14]],

            // Styling a specific cell by coordinate.
            //'B2' => ['font' => ['italic' => true]],

            // Styling an entire column.
            //'A1'  => ['font' => ['size' => 14]],
        ];
    }    

    public function columnFormats(): array
    {
        return [
            
            'F' =>NumberFormat::FORMAT_NUMBER,
        ];
    }
    
    public function registerEvents(): array
    {
        return [

            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->getDelegate()->getStyle('A2:F2')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('FF00FF00');
              
                 $event->sheet->getDelegate()->freezePane('A3');  
            },

        ];
    }        
    
}


