<?php
 
namespace App\Exports;
 
use DB;

use App\Http\Controllers\PenjualanController;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\BeforeExport;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class RekapSaleExport implements FromCollection, WithHeadings
{
    protected  $tgl1, $opt;

    function __construct($tgl1, $opt) {
        
        $this->tgl1 = $tgl1;
        $this->opt  = $opt;
    }
    
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        
        $data = PenjualanController::getdata_msale($this->tgl1, $this->opt);
        return $data;
        
    }
    
    
	/* header di excel */
    public function headings(): array
    {
        return ["id_sale","order_no","sale_tgl","sale_no","cust_id","sale_netto","sale_disc",
        "sale_bayar1","bayar1_tgl","bayar1_type","bayar1_note",
        "sale_bayar2","bayar2_tgl","bayar2_type","bayar2_note",
        "sale_bayar3","bayar3_tgl","bayar3_type","bayar3_note",
        "sale_bayar4","bayar4_tgl","bayar4_type","bayar4_note",
        "sale_bayar5","bayar5_tgl","bayar5_type","bayar5_note",
        "sale_posted","sale_lunas","sale_batal","sale_route","status_retur","keterangan","piutg_id",
        "user_id","created_at","updated_at"];
    }    
    
    
}


