<?php
 
namespace App\Exports;
 
use DB;

use App\Http\Controllers\ReportController;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithCustomCsvSettings;
use Maatwebsite\Excel\Concerns\WithHeadings;

class SaleCSVExport implements FromCollection, WithCustomCsvSettings, WithHeadings
{
    protected  $tgl1, $tgl2, $sup;

    function __construct($tgl1, $tgl2, $sup) {
        
        $this->tgl1 = $tgl1;
        $this->tgl2 = $tgl2;
        $this->sup  = $sup;
    }
    
    public function getCsvSettings(): array
    {
        return [
            'delimiter' => ','
        ];
    }

    public function headings(): array
    {
        return ["KODE","NAMA BARANG","STN","BRUTTO","DISC","POTONGAN"];
    }

    /**
    * @return \Illuminate\Support\Collection
    */

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        
        $data = ReportController::exportSale_XLS($this->tgl1, $this->tgl2, $this->sup);
        return $data;
        
    }
    

    
}


