<?php
 
namespace App\Exports;
 
use DB;

use App\Http\Controllers\ReportController;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\BeforeExport;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class StockExport implements FromCollection, WithHeadings, WithCustomStartCell, ShouldAutoSize, WithTitle, WithEvents, WithColumnWidths,WithStyles, WithColumnFormatting
{
    protected  $sup, $gdg;

    function __construct($sup, $gdg) {
        
        $this->sup  = $sup;
        $this->gdg  = $gdg;
    }
    
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        
        $data = ReportController::getReportStock($this->sup, $this->gdg);
        return $data;
        
    }
    
    
    public function startCell(): string
    {
        return 'A1';
    }
    
	/* header di excel */
    public function headings(): array
    {
        return [['Report Sisa Stock'],
        ["GDG","KODE","Nama Barang","STOCK B","STN B","HPP B","STOCK K","STN K","HPP K","TOTAL"]];
    }    


    public function title(): string
    {
    	return 'Report Sisa Stock';
    }
    
    public function columnWidths(): array
    {
        return [
            'A' => 10,
            'B' => 10,    
            'C' => 50,
            'D' => 10,
            'E' => 10,
            'F' => 10,
            'G' => 10,
            'H' => 10,
            'I' => 10,
            'J' => 20,
            
        ];
    }
    
    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            'A1'    => ['font' => ['bold' => true, 'size' => 14]],

            // Styling a specific cell by coordinate.
            //'B2' => ['font' => ['italic' => true]],

            // Styling an entire column.
            //'A1'  => ['font' => ['size' => 14]],
        ];
    }    

    public function columnFormats(): array
    {
        return [
            
            'B' =>NumberFormat::FORMAT_GENERAL_NUMBER,
            'D' =>NumberFormat::FORMAT_GENERAL_NUMBER,
            'F' =>NumberFormat::FORMAT_NUMBER,
            'G' =>NumberFormat::FORMAT_NUMBER,
            'I' =>NumberFormat::FORMAT_NUMBER,
            'J' =>NumberFormat::FORMAT_NUMBER
        ];
    }
    
    public function registerEvents(): array
    {
        return [

            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->getDelegate()->getStyle('A2:J2')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('FF00FF00');
              
                 $event->sheet->getDelegate()->freezePane('A3');  
            },

        ];
    }        
    
}


