<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Redirect;
use DataTables;
use DB;
use App\Category;
use App\User_logs;

class CategoryController extends Controller
{
   public function index()
   {
		
		return view('category.index');
   }
	
	public function getdata()
	{
		$category = DB::table('ms_category');
			
		return Datatables::of($category)->make(true);

	}

   public function store(Request $request)
   {
		$category = new Category;
        
		$category->cat_name = ucwords(strtolower($request['nama']));
		$category->user_id  = Auth::user()->id;
		$category->save();
	  
	  	// insert logs
		$usrnm	= Auth::user()->username;
		
		//$userlog = New User_logs;
		//$userlog->title		= 'New Master Category';
		//$userlog->content	= 'Category '.$request['nama'].' berhasil ditambahkan oleh '.$usrnm;
		//$userlog->user_id	= Auth::user()->id;
		//$userlog->save();
		
		$title  = 'New Master Category';
		$content= 'Category '.$request['nama'].' berhasil ditambahkan oleh '.$usrnm;
		$userid = Auth::user()->id;
		
		User_logs::UserLogs($title, $content, $userid);

		echo json_encode(array('msg'=>'success'));
   }

	public function show(){
	}

   public function edit($id)
   {
     $category = Category::find($id);
     echo json_encode($category);
   }

   public function update(Request $request, $id)
   {
      $category = Category::find($id);

      $category->cat_name 	= ucwords(strtolower($request['nama']));
      $category->update();
     
      	  	// insert logs
		$usrnm	= Auth::user()->username;
		
		$userlog = New User_logs;
		$userlog->title		= 'Edit Master Category';
		$userlog->content	= 'Category '.$request['nama'].' berhasil diedit oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
        $userlog->save();
      
	   echo json_encode(array('msg'=>'success'));
   }

}
