<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\Pegawai;
use App\Jabatan;
use App\MSGaji;
use App\DTGaji;
use App\Kasbon;
use App\LogGaji;
use App\User;
use App\User_logs;
use DataTables;


class GajiController extends Controller
{
   public function index()
   {
        $dt = Pegawai::with('get_jabatan')
                        ->orderBy('nama')->get();

		return view('gaji.index', compact('dt')); 
   }


   public function listData() {
     
    $gj = DB::table('ms_pegawai as A')
                ->select('A.id','A.nip', 'A.nama', 'B.jabatan', 'C.gaji_pokok','C.tunjangan','C.bonus')
                ->leftjoin('ms_jabatan as B', function($join){
                    $join->on('A.jabatan_id','=','B.id');
                })
                ->leftjoin('ms_gaji as C', function($join){
                    $join->on('A.id','=','C.peg_id');
                })
                ->orderby('A.nip')
                ->get();
                
     $data = [];
     foreach($gj as $list){
       
       $row = [];
       $row[] = $list->nip; 
       $row[] = $list->nama;
       $row[] = $list->jabatan;
       $row[] = '<div class="text-right">'.format_uang($list->gaji_pokok).'&nbsp;&nbsp;&nbsp;</div>';
       $row[] = '<div class="text-right">'.format_uang($list->tunjangan).'&nbsp;&nbsp;&nbsp;</div>';
       $row[] = '<div class="text-right">'.format_uang($list->bonus).'&nbsp;&nbsp;&nbsp;</div>';

       $row[] = '<div class="btn-btn">
                    <a onclick="editForm('.$list->id.')" class="btn btn-flat btn-xs"><i class="fa fa-pencil"></i></a>
               </div>';
       $data[] = $row;
     }

     return response()->json(['data'=>$data]);
	 
   }

   public function store(Request $request)
   {

        $peg = new MSGaji;
      
        $peg->peg_id    = $request['peg'];
        $peg->gaji_pokok= $request['gp'];
        $peg->tunjangan = $request['tjg'];
        $peg->deskripsi = $request['ket'];
	    $peg->user_id	= Auth::user()->id;
        $peg->save();

        echo json_encode(array('msg'=>'success'));
   }
   
   public function show($id){
       $dt = MSGaji::where('peg_id',$id)->first();
       echo json_encode($dt);
   }

   public function edit($id)
   {
        $gj = MSGaji::where('peg_id',$id)
                        ->first();   
                        
        if(empty($gj)){
            return json_encode(['msg'=>'error']);
        }else{
            $dt = Pegawai::find($id);
            $jb = Jabatan::find($dt->jabatan_id);
            
            echo json_encode(array_merge(json_decode($jb, true), json_decode($gj, true), json_decode($dt, true)));
        }
   }

   public function update(Request $request, $id)
   {
        $peg = MSGaji::where('peg_id',$id)->first();
      
        $peg->gaji_pokok= $request['gp'];
        $peg->tunjangan = $request['tjg'];
        $peg->deskripsi = $request['ket'];
	    $peg->user_id	= Auth::user()->id;
        $peg->update();

        echo json_encode(array('msg'=>'success'));
   }
   
    public function indexproses(){
        
        $thn=date('Y');
        $bln=date('m');
        $prd=$thn.'-'.$bln;
        
        return view('gaji.prosesgaji',compact('prd'));
    }

    function prosesData(Request $request){
        
        $prd = $request['masa'];
        
        $log = LogGaji::where('periode', $prd)
                            ->first();
                            
        if(empty($log)){
            /* proses gaji */
            
            $gg = DB::table('ms_pegawai as A')
                        ->select('A.id', 'C.gaji_pokok','C.tunjangan', 'C.bonus')
                        ->leftjoin('ms_gaji as C', function($join){
                            $join->on('A.id', 'C.peg_id');
                        })
                        ->where('A.is_active', 1)
                        ->get();
                        
            foreach($gg as $dt){
                
                $kb = Kasbon::where('peg_id', $dt->id)
                                ->where('periode', $prd)
                                ->where('is_lunas', 0)
                                ->first();
                        
                
                if(empty($kb)){  
                    $pot=0;
                    $berhasil=false;
                }else{
                    $pot = $kb->nominal; $berhasil=true;
                }
                
                $gj = new DTGaji;
                
                $gj->periode    = $prd;
                $gj->peg_id     = $dt->id;
                $gj->gaji_pokok = $dt->gaji_pokok;
                $gj->tunjangan  = $dt->tunjangan;
                $gj->bonus      = $dt->bonus;
                $gj->potongan   = $pot;
                $gj->save();
                
                if($berhasil==true){
                    $kb->is_lunas=1;
                    $kb->update();
                }
                
            }
            
            $lg = new LogGaji;
            $lg->periode    = $prd;
            $lg->user_id    = Auth::user()->id;
            $lg->save();
        }
        
        return json_encode(['msg'=>'success']);
    }
    
    
    function tampilData($prd){
        
        $gg = DB::table('dt_gaji as A')
                    ->select('A.id', 'A.periode','A.peg_id','A.gaji_pokok','A.tunjangan', 'A.bonus','A.potongan','B.nip', 'B.nama','D.jabatan')
                    ->leftjoin('ms_pegawai as B', function($join){
                        $join->on('A.peg_id', 'B.id');
                    })
                    ->leftjoin('ms_jabatan as D', function($join){
                        $join->on('B.jabatan_id','=','D.id');
                    })
                    ->where('A.periode', $prd)
                    ->orderBy('B.nip')
                    ->get();
        
        $data=[];
        foreach($gg as $gj){
            
            $row=[];
            $row[]=$gj->periode;
            $row[]=$gj->nip;
            $row[]=$gj->nama;
            $row[]=$gj->jabatan;
            $row[]='<div class="text-right">'.format_uang($gj->gaji_pokok).'&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div class="text-right">'.format_uang($gj->tunjangan).'&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div class="text-right">'.format_uang($gj->bonus).'&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div class="text-right">'.format_uang($gj->potongan).'&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div class="text-right">'.format_uang($gj->gaji_pokok + $gj->tunjangan + $gj->bonus - $gj->potongan).'&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div clas="btn-btn">
                        <a onclick="editgaji('.$gj->id.')" class="btn btn-success btn-xs"><i class="fa fa-edit"></i></a>
                    </div>';
            
            $data[]=$row;
            
        }
        
        echo json_encode(['data'=>$data]);
   
    }
    
    function reportGaji(Request $request){
        
        $prd = $request['masa'];
        
        $dt = DB::table('dt_gaji as A')
                    ->select('A.id', 'A.periode','A.peg_id','A.gaji_pokok','A.tunjangan', 'A.bonus','A.potongan','B.nip', 'B.nama','D.jabatan', 'B.bank','B.noacct')
                    ->leftjoin('ms_pegawai as B', function($join){
                        $join->on('A.peg_id', 'B.id');
                    })
                    ->leftjoin('ms_jabatan as D', function($join){
                        $join->on('B.jabatan_id','=','D.id');
                    })
                    ->where('A.periode', $prd)
                    ->orderBy('B.nip')
                    ->get();        

        $ttl=0;
        foreach($dt as $gj){ $ttl += ($gj->gaji_pokok+$gj->tunjangan+$gj->bonus-$gj->potongan); }
                    
        $no=1;
        
        return view('gaji.reportgaji', compact('no','prd','dt','ttl'));
        
    }
    
    function editGaji($id){
        
        $gj = DTGaji::find($id);
        $peg = Pegawai::find($gj->peg_id);
        
        echo json_encode(array_merge(json_decode($peg, true), json_decode($gj, true)));
        
    }
    
    function simpanEditGaji(Request $request, $id){
        
        $gj = DTGaji::find($id);
        
        $gj->bonus  = $request['bonus'];
        $gj->update();
        
        echo json_encode(['msg'=>'success']);
    }
    
    
}
