<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\ProductSup;
use App\Supplier;
use App\City;
use App\Stock;
use App\Gudang;
use App\Invoice;
use App\InvoiceDetail;
use App\User_logs;
use DataTables;
use DB;
use Auth;
Use Redirect;

class InvoiceController extends Controller
{

	public function index()
	{		
		$supplier = Supplier::all();
        $gdg      = Gudang::all();
		return view('invoice.index', compact('supplier','gdg'));
	}
	
	public function editHarga(){
	    return view('invoice.editharga');
	}
	
	
	public function history()
	{		
		return view('invoice.history');
	}	


    function getheader()
    {
		$tglnow = date("Y-m-d");

		$inv = Invoice::with('get_supplier', 'get_gudang')
							->where('inv_batal',0)		                    
		                   	->where('inv_posted',0)
							->orderby('inv_no','ASC')
							->get();
		
		$data = [];
		
		foreach($inv as $list)
		{
			$row = [];
            
            $row[] = $list->no_urut;
			$row[] = $list->inv_no;
			$row[] = $list->get_gudang->kode;
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = tanggal_indonesia($list->inv_jt, false);
			$row[] = $list->get_supplier->sup_nama;
			$row[] = $list->inv_ppn;
			$row[] = $list->inv_disc;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_netto).'&nbsp;&nbsp;</div>';
			$row[] = $list->deskripsi;
			
			if($list->inv_posted==1){
			    $row[]="";
			}else{
		        $row[] = '<div class="btn-btn">
				                <a onclick="addDetail('.$list->id.')" class="btn btn-success btn-xs"><i class="fa fa-plus"></i></a>
				                <a onclick="editHeader('.$list->id.')" class="btn btn-danger btn-xs"><i class="fa fa-pencil-square-o"></i></a>
				            </div>';	
			}

		   $data[] = $row;
		}

		return response()->json(["data"=>$data]);								
			
    }
    
    function headeredit()
    {

		$inv = Invoice::with('get_supplier', 'get_gudang')
							->where('inv_batal',0)		                    
		                   	->where('inv_posted',1)
		                   	->where('inv_lunas',0)
							->orderby('inv_no','ASC')
							->get();
		
		$data = [];
		
		foreach($inv as $list)
		{
			$row = [];
            
            $row[] = $list->no_urut;
			$row[] = $list->inv_no;
			$row[] = $list->get_gudang->kode;
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = tanggal_indonesia($list->inv_jt, false);
			$row[] = $list->get_supplier->sup_nama;
			$row[] = $list->inv_ppn;
			$row[] = $list->inv_disc;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_netto).'&nbsp;&nbsp;</div>';
			
	        $row[] = '<div class="btn-btn">
				        <a onclick="addDetail('.$list->id.')" class="btn btn-success btn-xs"><i class="fa fa-pencil"></i></a>
				        <a onclick="batal('.$list->id.')" class="btn btn-danger btn-xs"><i class="fa fa-times"></i></a>
		            </div>';	
		   $data[] = $row;
		}

		return response()->json(["data"=>$data]);								
			
    }    
    
    public function hitungJT($sup, $tglinv){
        
        $supl = Supplier::find($sup);
        $jt  = date('Y-m-d', strtotime(' +'.$supl->lama_kredit.' day', strtotime( $tglinv ))); 
        
        echo json_encode(["tgljt"=>$jt]);
    }
    
///-- create new invoice
	public function store(Request $request)
	{
		$idsup		= $request['supl'];
		$dsc		= $request['dis'];
		$ppn		= $request['ppn'];
		$tglinv		= $request['tglinv'];
		$tgljt		= $request['tgljt'];
		$noinv		= $request['inv'];
		
		if ($dsc<0){ return json_encode(array('msg'=>'discerror')); }
		
		$nourut = $this->cekNoUrut();
		
		$sup	= Supplier::find($idsup);
	
		$invoice	= New Invoice;
		$invoice->no_urut   = $nourut;
		$invoice->inv_no	= $noinv;
		$invoice->gudang_id = $request['tuju'];
		$invoice->supp_id	= $idsup;
		$invoice->inv_tgl	= $tglinv;
		$invoice->inv_jt	= $tgljt;
		$invoice->inv_disc	= $dsc;
		$invoice->inv_ppn	= $ppn;
		$invoice->deskripsi = $request['ket'];
		$invoice->user_id	= Auth::user()->id;
		
		$invoice->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$title		= 'Invoice Baru '.$nourut;
			$content	= 'Invoice No.'.$noinv.' '.$sup->sup_nama.' berhasil dicreate oleh '.$usrnm;
			$userid	= Auth::user()->id;

            User_logs::UserLogs($title, $content, $userid);

			echo json_encode(array('msg'=>'success'));
			       			
	}
	
    public static function cekNoUrut(){
    	/* cek no terakhir */
		$noftr	= '';
		$tahun	= date('y');
		$bulan  = date('m');
		$nomor	="INV/".$tahun.$bulan."/";		/* INV/2205/0001*/
			
		$ada_no	= DB::table('ms_invoice')
						->select(DB::raw('SUBSTR(MAX(no_urut),10,4) as last_no'))
						->where('no_urut', 'LIKE', "$nomor%" )
						->first();
			
		if (!empty($ada_no))
		{
			$no	= $ada_no->last_no + 1;
				
			$nomorbaru 	= sprintf("%04s", $no);		//format: IN/202101/0001
			$noftr = $nomor.$nomorbaru;
			
		} else {
			$nomorbaru = "0001";
			$noftr = $nomor.$nomorbaru;
		}
		
		return $noftr;
    }			
	
	
	public function update(Request $request, $id){
	    
	    $dis    = $request['dis'];
	    $ppn    = $request['ppn'];
	    
	    $inv = Invoice::find($id);	 
	    $sup = Supplier::find($inv->supp_id);
        $dtl = InvoiceDetail::where('inv_id', $id)
                            ->get();
        $sub=0;
        foreach($dtl as $list){
            $sub += ($list->qty * $list->harga)-($list->qty * $list->harga * $list->disc_1/100);
        }
        
        $disc = $sub * $dis /100;
        $ppn2 = ($sub - $disc) * $ppn/100;
        $ttl = $sub - $disc + $ppn2;
        
	    $inv->inv_no        = $request['inv'];
	    $inv->gudang_id     = $request['tuju'];
	    $inv->inv_tgl       = $request['tglinv'];
	    $inv->inv_jt        = $request['tgljt'];
	    $inv->inv_disc      = $dis;
	    $inv->inv_ppn       = $ppn;
        $inv->inv_brutto    = $sub;
        $inv->inv_netto     = $ttl;	  
        $inv->deskripsi     = $request['ket'];
	    $inv->update();	            

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$title		= 'Edit Invoice ';
			$content	= 'Invoice No.'.$request['inv'].' '.$sup->sup_nama.' berhasil diedit oleh '.$usrnm;
			$userid	    = Auth::user()->id;
			
		User_logs::UserLogs($title, $content, $userid);
			
	    echo json_encode(['msg'=>'success']);
	    
	}
	
    public function edit($id)
    {
      $inv = Invoice::find($id);
      $sup = Supplier::find($inv->supp_id);
      
      echo json_encode(array_merge(json_decode($sup, true), json_decode($inv, true)));
    }
    
    public function show($id){
        $dt = Invoice::find($id);
        echo json_encode($dt);
    }

    public function dataDetail($id){
        
        $inv = Invoice::find($id);
        $dtl = InvoiceDetail::with('get_product')
                        ->where('inv_id', $id)
                        ->get();
                        
        $data=[];
        $ttl=0;
        foreach($dtl as $dt){
            
            $jlh=($dt->qty * $dt->harga)-($dt->qty * $dt->harga * $dt->disc_1/100);
            $ttl+= $jlh;
            
            $row=[];
            $row[]=$dt->get_product->nama_brg;
            $row[]=$dt->satuan.'/'.$dt->isi;
            $row[]='<div style="text-align:right">'.$dt->qty.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';            
            $row[]='<div style="text-align:right">'.format_uang($dt->harga).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.$dt->disc_1.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.format_uang($jlh).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            
            if($inv->inv_posted==1){
                $row[]="";
            }else{
                $row[]='<a onclick="editDetail('.$dt->id.')" class="btn btn-flat btn-xs"><i class="fa fa-pencil"></i></a>';
            }
            
            $data[]=$row;
        }
        
        $row=[];

        $row[]="";
        $row[]="";
        $row[]="";
        $row[]="Sub Total";
        $row[]="";        
        $row[]='<div style="text-align:right">'.format_uang($ttl).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
        $row[]="";
            
        $data[]=$row;     
        
        return response()->json(["data"=>$data]);
    }	
    
    /* untuk edit harga */
    public function DetailEdit($id){
        
        $inv = Invoice::find($id);
        $dtl = InvoiceDetail::with('get_product')
                        ->where('inv_id', $id)
                        ->get();
                        
        $data=[];
        $ttl=0;
        foreach($dtl as $dt){
            
            $jlh=($dt->qty * $dt->harga)-($dt->qty * $dt->harga * $dt->disc_1/100);
            $ttl+= $jlh;
            
            $row=[];
            $row[]=$dt->get_product->nama_brg;
            $row[]=$dt->satuan.'/'.$dt->isi;
            $row[]='<div style="text-align:right">'.$dt->qty.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';            
            $row[]='<div style="text-align:right">'.format_uang($dt->harga).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.$dt->disc_1.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.format_uang($jlh).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            
            $row[]='<a onclick="editHarga('.$dt->id.')" class="btn btn-flat btn-xs"><i class="fa fa-pencil"></i></a>';

            $data[]=$row;
        }
        
        $row=[];

        $row[]="";
        $row[]="";
        $row[]="";
        $row[]="Sub Total";
        $row[]="";        
        $row[]='<div style="text-align:right">'.format_uang($ttl).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
        $row[]="";
            
        $data[]=$row;     
        
        return response()->json(["data"=>$data]);
    }	    
    
    public function loadSummary($id){
        
        $inv = Invoice::find($id);
        $dtl = InvoiceDetail::where('inv_id', $id)
                            ->get();
        $sub=0;
        foreach($dtl as $list){
            $sub += ($list->qty * $list->harga)-($list->qty * $list->harga * $list->disc_1/100);
        }
        
        $dis = $sub * $inv->inv_disc /100;
        $ppn = ($sub - $dis) * $inv->inv_ppn/100;
        $ttl = $sub - $dis + $ppn;
        
        $inv->inv_brutto   = $sub;
        $inv->inv_netto    = $ttl;
        $inv->update();
        
        echo json_encode(["totalftr"=>format_uang($ttl)]);
    }	

    public function listProduk($id, $tp){
        
        if($tp=="2"){
            $prd = DB::table('ms_product as A')
                    ->select('B.id', 'A.nama_brg', 'B.satuan', 'B.isi', 'B.harga')
                    ->leftjoin('product_sup as B', function($join){
                            $join->on('A.id', '=', 'B.product_id');  
                        })
                    ->where('B.sup_id', $id)
                    ->get();
        }else{
            $prd = DB::table('ms_product as A')
                    ->select('A.id', 'A.nama_brg', 'A.satuan', 'A.isi', 'A.harga')
                    ->orderBy('A.nama_brg')
                    ->get();            
        }


		$data = [];
		
		foreach($prd as $list){
			$row = [];
			$row[] = $list->nama_brg;
			$row[] = $list->satuan.'/'.$list->isi ;
            $row[] = '<div style="text-align:right">'.format_uang($list->harga).'</div>' ;
			
  		    $row[] = '<div class="btn-btn">
						<a onclick="selectProduk('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-check"></i></a>
					</div>';

			$data[] = $row;
        }

        return response()->json(["data"=>$data]);        
    }
    
    function tampilProductList($id, $tp){
        
        if($tp=="1"){
            $prd = Product::find($id);
            echo json_encode($prd);
        }else{
            $lst = ProductSup::find($id);
            $prd = Product::find($lst->product_id);
            
            echo json_encode(array_merge(json_decode($prd, true), json_decode($lst, true)));            
        }
    }    
    
    
    public function tampilKemasan($id){
        
        $kms = ProductSub::find($id);
        $prd = Product::find($kms->product_id);
        $dt = $kms->satuan." / ".$kms->volume;
        $brg= $prd->kode_brg.' - '.$prd->nama_brg;
        
        echo json_encode(["kemasan"=>$dt, "harga"=>$kms->hpp, "namaprd"=>$brg]);
    }
    
    public function addDetail(Request $request){

        $idsup  = $request['idsup'];       /* pada form add_detail */
        $idinv  = $request['idinv2'];
        $qty    = $request['qty'];
        $hg     = $request['harga'];
        $tp     = $request['tp'];
        $idprd  = $request['iddetail'];
        
        $inv = Invoice::find($idinv);
        
        if($tp=="2"){
            $lst = ProductSup::find($idprd);
            $prd = Product::find($lst->product_id);
            $stn = $lst->satuan;
            $isi = $lst->isi;
        }else{
            $prd = Product::find($idprd);
            $stn = $prd->satuan;
            $isi = $prd->isi;
        }
        
        try{    
            $dt = new InvoiceDetail;
            $dt->inv_id         = $inv->id;
            $dt->product_id     = $prd->id;
            $dt->product_name   = $prd->nama_brg;
            $dt->satuan         = $stn;
            $dt->isi            = $isi;
            $dt->harga          = $hg;
            $dt->disc_1         = $request['dis1'];
            $dt->qty            = $qty;
            $dt->save();
            
            echo json_encode(['msg'=>'success']);
        }
        catch (Exeption $e){
            return response (['status' => false,'errors' => $e->getMessage()]);
        }
    }
    
    public function editDetail($id){
        
        $dt = InvoiceDetail::find($id);
        echo json_encode($dt);
        
    }
    
    public function simpanEdit(Request $request, $id){

        $dt = InvoiceDetail::find($id);
        $inv = Invoice::find($dt->inv_id);
        
        $hg     = $request['harga'];
        $oldqty = $dt->qty;
        $newqty = $request['qty'];
        
        $dt->disc_1         = $request['dis1'];
        $dt->qty            = $newqty;
        $dt->harga          = $hg;
        $dt->update();
        
        echo json_encode(['msg'=>'success']);
        
    }
    
    public function simpanEditHarga(Request $request, $id){

        $dt = InvoiceDetail::find($id);
        $inv = Invoice::find($dt->inv_id);
        
        $hg  = $request['harga'];

        $dt->disc_1         = $request['dis1'];
        $dt->harga          = $hg;
        $dt->update();
        
        echo json_encode(['msg'=>'success']);
        
    }    
    
    public function posting(Request $request){
    
        $inv = Invoice::find($request['idinv']);
        $dt  = InvoiceDetail::where('inv_id', $inv->id)
                                ->where('is_posted', 0)
                                ->get();
        
    // return json_encode(['msg'=>'success']);   
        
        foreach($dt as $list){
            
            $this->updStock($list->product_id, $list->qty * $list->isi, $inv->gudang_id, $inv->inv_tgl);

            /* update status posting */
            $pp = InvoiceDetail::find($list->id);
            $pp->is_posted = 1;
            $pp->update();
            
        }
        
        $inv->inv_posted=1;
        $inv->update();

	// insert logs
			$usrnm	= Auth::user()->username;

			$title		= 'Posting Invoice ';
			$content	= 'Invoice No.'.$inv->inv_no.' berhasil diposting oleh '.$usrnm;
			$userid	    = Auth::user()->id;

        User_logs::UserLogs($title, $content, $userid);
        
        echo json_encode(['msg'=>'success']);
    }

    public function updStock($id, $qty, $gdg, $tgl ){
        
        $inv = Product::find($id);
        
        /* jika status inventory baru update stock */
        if($inv->is_stock==1){
            $stk = Stock::where('product_id', $id)
                            ->where('gudang_id', $gdg)
                            ->first();
                            
            if(empty($stk)){
                $dt = New Stock;
                $dt->gudang_id  = $gdg;
                $dt->product_id = $id;
                $dt->stock_in   = $qty;
                $dt->tgl_awal   = $tgl;
                $dt->tgl_in     = $tgl;
                $dt->stock_akhir= $qty;
                $dt->save();
            }else{
                
                $stk->stock_in      += $qty;
                $stk->stock_akhir   += $qty;
                $stk->tgl_in        = $tgl;
                $stk->update();
            }
        }
        return true;
    }

    function batal($id){
        
        $inv = Invoice::find($id);
        $inv->inv_batal=1;
        $inv->update();
        
	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= "Pembatalan Invoice";
			$userlog->content	= "Invoice ".$inv->no_urut.' - '.$inv->inv_no.'  dibatalkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));        
        
    }    
    
    
    public function printFaktur($id){
        
        $inv = Invoice::find($id);
        $gdg = Gudang::find($inv->gudang_id);
        $dt  = InvoiceDetail::with('get_product')
                                ->where('inv_id', $id)
                                ->where('qty', '!=',0)
                                ->get();  
                            
        $sup = Supplier::find($inv->supp_id);                    

        $sub=0;
        foreach($dt as $list){
            $sub += ($list->qty * $list->harga)-($list->qty * $list->harga * $list->disc_1/100);
        }
        
        $dis = $sub * $inv->inv_disc /100;
        $ppn = ($sub - $dis) * $inv->inv_ppn/100;
        $ttl = round($sub - $dis + $ppn);
        
        return view('invoice.faktur', compact('inv','dt','sub', 'dis','ppn','ttl','sup','gdg'));
    }
    
/* print faktur printer dotmatrix */
    public function printFaktur_matrix($id){
        
        $inv = Invoice::find($id);
        $dt  = InvoiceDetail::with('get_product')
                                ->where('inv_id', $id)
                                ->get();  
                            
        $sup = Supplier::find($inv->supp_id); 
        
        $pin    = 0;
        $on_ms  = 120;
        $off_ms = 240;
        $feed   = "\x0c";
        
        $lebarkolom = 80;
        $bold1      = Chr(27) . Chr(69);
        $bold0      = Chr(27) . Chr(70);
        $initialized= chr(27) . chr(64);
        $condensed1 = chr(15);
        $condensed0 = chr(18);

        $setLeft    = chr(27) . "a" . chr(0);
        $setCenter  = chr(27) . "a" . chr(1);
        $setRight   = chr(27) . "a" . chr(2); 
    
        $fontNormal	= chr(27) . "!" . chr(0);
        $fontKecil	= chr(27) . "!" . chr(1);
        $fontTebal	= chr(27) . "!" . chr(8);
        $fontBesar	= chr(27) . "!" . chr(16);
        $fontLebar	= chr(27) . "!" . chr(32);
        $fontUline	= chr(27) . "!" . chr(128);
        $fontSans   = chr(27) . "k" . chr(1);

        $grs=PrinterController::replicate('-',$lebarkolom);

        $Data  = $initialized;
        $Data .= $condensed0;

        $Data .= $fontTebal.PrinterController::center("INVOICE PEMBELIAN", $lebarkolom)."\n";
        $Data .= PrinterController::strKarakter($sup->sup_nama,50).PrinterController::rataKanan(tanggal_indonesia($inv->inv_tgl, false),30)."\n";
        $Data .= PrinterController::strKarakter("Faktur  : ".$inv->inv_no,80)."\n";
        $Data .= PrinterController::strKarakter("J.Tempo : ".tanggal_indonesia($inv->inv_jt, false),50)."\n";
        $Data .= PrinterController::strKarakter("Disc.   : ".PrinterController::strAngka($inv->inv_disc,3)."%   PPN : ".PrinterController::strAngka($inv->inv_ppn,3)."%", 80)."\n";

        $Data .= $condensed0;        
        $Data .= $grs."\n";
        //$Data .= $fontKecil.$fontTebal;
        
        /*        0        1         2         3         4         5         6         7         8         9*/
        /*        123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.   */
        /*        1234 123456789.123456789.123456789.123456789. 9999XXX 9,999,999  99% 99,999,999*/
        $Data .= "KODE  Nama Barang                              --QTY--     Harga  Disc    Jumlah\n";
        $Data .= $grs."\n";
        
        $no = 0;
        $ttl = 0;
        
        foreach($dt as $dtl){
            $no++;
            $jlh = ($dtl->qty * $dtl->harga)-($dtl->qty*$dtl->harga*$dtl->disc_1/100); 
            $ttl += $jlh;
            
            $kd = $condensed1.PrinterController::strKarakter($dtl->get_product->kode_brg,8).$condensed0;
            $nm = PrinterController::strKarakter(substr($dtl->product_name,0,40),40);
            $qq = PrinterController::rataKanan(format_uang($dtl->qty),4).substr($dtl->satuan,0,3);
            $hg = PrinterController::strAngka($dtl->harga,9);
            
            if($dtl->disc_1>0){
                $ds = PrinterController::strAngka($dtl->disc_1,3)."%";
            }else{
                $ds = "  --";
            }
            
            $jl = PrinterController::strAngka($jlh,10);
            
            $Data .=$kd." ".$nm." ".$qq." ".$hg." ".$ds." ".$jl."\n";
        }
        
        $Data .= $grs."\n";
        $Data .= PrinterController::space(55)."Sub Total   ".PrinterController::strAngka($ttl,13)."\n";
        
        $dis =0;
        $ppn =0;
        
        if($inv->inv_disc>0){
            $dis = round($ttl * $inv->inv_disc/100);
            $Data .= PrinterController::space(55)."Disc ".PrinterController::strAngka($inv->inv_disc,3)."%   ".PrinterController::strAngka($dis,13)."\n";
        }
        
        $ttl -= $dis;

        if($inv->inv_ppn>0){
            $ppn = round($ttl * $inv->inv_ppn/100);
            $Data .= PrinterController::space(55)."PPN         ".PrinterController::strAngka($ppn,13)."\n";
        }     
        
        $Data .= PrinterController::space(55)."# TOTAL #   ".PrinterController::strAngka($ppn+$ttl,13)."\n";
        $Data .= $condensed1.terbilang(round($ttl+$ppn))." rupiah# \n\n";
        $Data .= $condensed0.PrinterController::space(10).PrinterController::strKarakter('Penerima', 40).'Mengetahui'."\n\n\n";
        //$Data .= PrinterController::space(10).PrinterController::strKarakter('Cap & Nama Jelas',40).'Admin'."\n";
        
        $Data .= $feed;

        $dt = "intent:base64," . base64_encode($Data) . "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end;";
        $output = ["data"=>$dt];

        return response()->json($output);

    }
        
    
/*------------------------------------------------------*/
    function history_header()
    {

		$inv = Invoice::with('get_supplier','get_gudang')
                            ->where('inv_batal',1)
		                   	->orWhere('inv_posted',1)
							->orderby('inv_no','DESC')
							->get();
		
		$data = [];
		
		foreach($inv as $list)
		{
		    
		    if($list->inv_lunas==1){ $lns='<label class="label-success">&nbsp;&#10003&nbsp;</label>'; }else{ $lns='<label class="label-warning">&nbsp;x&nbsp;</label>'; }
		    if($list->inv_batal==1){ $lns='<label class="label-danger">&nbsp;btl&nbsp;</label>';}
		    
			$row = [];
            
            $row[] = $list->no_urut;
			$row[] = $list->inv_no;
			$row[] = $list->get_gudang->kode;
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = tanggal_indonesia($list->inv_jt, false);
			$row[] = $list->get_supplier->sup_nama;
			$row[] = $list->inv_ppn;
			$row[] = $list->inv_disc;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_netto).'</div>';
			$row[] = $lns;
	        $row[] = '<div class="btn-btn">
				        <a onclick="showDetail('.$list->id.')" class="btn btn-success btn-sm"><i class="fa fa-eye"></i></a>
				    </div>';	
			
		    $data[] = $row;
		}

		return response()->json(["data"=>$data]);								
			
    }
    


/////////////////////////////////////////////////////////////////////////


/* reprint inv */
    public function reprint($id)
    {
		session(['idinv'=>$id]);
		return Redirect::route('invoicedetail.reprint');				//cetak po
    }

	
}
