<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Datatables;
use Auth;
use DB;
use App\User;
use App\Setting;
use App\Salesman;
use App\MSOrder;
use App\DTOrder;
use App\Customer;
use App\Product;


class OrderController extends Controller
{
    
    public function index(){
        return view('order.index_sales');
    }

    public function orderSales(){
        $ord = MSOrder::where('tanggal', date('Y-m-d'))
                        ->orderBy('order_no', 'ASC')
                        ->where('order_status', 1)
                        ->get();
                        
        $no=0;
        $data=[];
        foreach($ord as $list)
        {
            $no++;
            $row=[];
            $row[]= $no;
            $row[]= User::cekUser($list->sales_id)->username;
            $row[]= $list->order_no;
            $row[]= Customer::cekCustomer($list->cust_id)->cus_name;
            $row[]= '<div class="text-right" style="font-weight:bold;">'.$list->order_disc.'</div>';
            $row[]= '<div class="text-right" style="font-weight:bold;">'.format_uang($list->order_total).'</div>';
            $row[]= '<a onclick="tampilOrder('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-list"></i></a>';

            $data[]= $row;            
        }
        
        $output = ["data" => $data];
		return response()->json($output);    
       
    }
   
   public function listOrder($id){
    
        $tgl = date('Y-m-d');
        $ord = MSOrder::where('tanggal', $tgl)
                        ->where('sales_id', $id)
                        ->get();
        
        $data=[];
        foreach($ord as $list)
        {
            $row=[];

            if($list->order_status==1)
            {
                $row[]='<a onclick="addDetail('.$list->id.')" class="card" style="width:100%; height:auto; background-color:#6495ED; cursor:pointer;">
                    <div class="card-block">
                        <div class="card-body">
                            <h6>'.Customer::cekCustomer($list->cust_id)->cus_name.'</h6>
                            
                            <h5>'.$list->order_no.'</h5>
                            <h5 class="text-right" style="margin-top:-32px; color:white">Discount: '.$list->order_disc.'</h5>
                            <hr style="margin-top:-5px;">
                            <h4 class="text-right" style="color:white; font-weight:bold;">'.format_uang($list->order_total).'</h4>
                        </div>  
                    </div>
                    </a>';

            }else{
                $row[]='<a onclick="addDetail('.$list->id.')" class="card" style="width:100%; height:auto; background-color:#6495ED; cursor:pointer;">
                    <div class="card-block">
                        <div class="card-body">
                            <h6>'.Customer::cekCustomer($list->cust_id)->cus_name.'</h6>
                            
                            <h5>'.$list->order_no.'</h5>
                            <h5 class="text-right" style="margin-top:-32px;">Discount: '.$list->order_disc.'</h5>
                            <hr style="margin-top:-5px;">
                            <h4 class="text-right">'.format_uang($list->order_total).'</h4>
                        </div>  
                    </div>
                    </a>';
            }
            
            $data[]=$row;
        }
    	
    	$output = array("data" => $data);
		return response()->json($output);    
       
   }
   

   public function store(Request $request)
   {

        $sls= Salesman::where('user_id', Auth::user()->id)->first();
        $kd = $sls->sales_kode;
        
		$noorder  = "";
		$tahun	= date('Y');
		$bulan  = date('m');
		
		$nomor	= $kd."/".$tahun.$bulan."/";		
		$ada_no	= DB::table('ms_order')
    					->select(DB::raw('SUBSTR(MAX(order_no),12,4) as last_no'))
    					->where('order_no', 'LIKE', "$nomor%" )->get();

		$jml	= $ada_no->count();
			
		if ($jml >0)
		{
			foreach( $ada_no as $ada ){	$no	= $ada->last_no; }
			$no1	= $no + 1;
				
			$nomorbaru 	= sprintf("%04s", $no1);		//format: INV/2019/00001
			$noorder = $nomor.$nomorbaru;
			
		} else {
			$nomorbaru = "0001";
			$noorder = $nomor.$nomorbaru;
		}
		
		$ord = new MSOrder;
		$ord->tanggal   = date('Y-m-d');
		$ord->order_no  = $noorder;
		$ord->sales_id  = Auth::user()->id;
		$ord->cust_id   = $request['cus'];
		$ord->order_disc= $request['disc'];
		$ord->save();
		
		echo json_encode(array('msg'=>'success'));
   }

   public function edit($id)
   {
 
   }
   
   public function show($id)
   {
       
   }

   public function update(Request $request, $id)
   {
      $origin = Origin::find($id);
      $origin->org_name = $request['nama'];
	  $origin->user_id  = Auth::user()->id;
      $origin->update();
   }


/**detail--------------------*/
   public function listDetail($id){
    
        $oo = MSOrder::find($id);
        
        $dt = DTOrder::where('order_id', $id)
                        ->get();
        
        
        $data=[];
        foreach($dt as $list)
        {
            $row=[];
            $row[]=Product::cekProduct($list->product_id)->nama_brg;
            $row[]=format_uang($list->harga);
            $row[]=$list->disc;
            $row[]=$list->qty;
            
            if($oo->order_status==0){
                $row[]='<a onclick="editDetail('.$list->id.')" class="btn btn-flat btn-sm" style="width:40px; height:40px;margin-right:-5px;margin-bottom:5px;"><i class="fa fa-pencil-square-o fa-3x"></i></a>';
            }else{ 
                $row[]='<a class="btn btn-flat btn-sm" style="width:40px; height:40px;margin-right:-5px;margin-bottom:5px;color:gray;"><i class="fa fa-ban fa-3x"></i></a>';
            }                
 
            $data[]=$row;
        }
    	
    	$output = array("data" => $data);
		return response()->json($output);    
       
   }
   
   public function loadHdr($id){
       $ord = MSOrder::find($id);
       $cus = Customer::find($ord->cust_id);
       
       echo json_encode(array_merge(json_decode($ord, true),json_decode($cus, true)));     
   }
   
	public function listProduct(){
		
		$prd = Product::where('is_active',1)
		                ->get();
		
		$data = [];
		
		foreach($prd as $list){
			$row = [];
			
			$row[] = '<div class="text-left" style="width:220px;">'.$list->nama_brg.'</div>' ;
            $row[] = '<div class="text-right" style="width:100px;">'.format_uang($list->harga_retail).'</div>';
  		    $row[] = '<a onclick="selectProduct('.$list->id.')" class="btn btn-flat btn-sm" style="width:60px; height:60px;margin-right:-15px;margin-bottom:-25px;"><i class="fa fa-check-square-o fa-2x"></i></a>';

			$data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);
	}	   
	
	public function tampilProduct($id){
	    $prd = Product::find($id);
	    echo json_encode($prd);
	}

    public function simpanDetail(Request $request){
        
        $or = new DTOrder;
        $or->order_id   = $request['orderid'];
        $or->product_id = $request['brg'];
        $or->qty        = $request['qty'];
        $or->harga      = $request['harga'];
        $or->disc       = $request['disc1'];
        $or->save();
        
        $aa = DTOrder::where('order_id', $request['orderid'])->get();
        $tl=0;
        foreach($aa as $dd)
        {
            $tl += ($dd->qty  *$dd->harga)-($dd->qty * $dd->harga *$dd->disc/100);
        }
        
        $oo = MSOrder::find($request['orderid']);
        $ttl = $tl - ($tl * $oo->order_disc/100);
        $oo->order_total = $ttl;
        $oo->update();
        
        echo json_encode(['msg'=>'success']);
        
    }
    
    public function editDetail($id){
        $dt = DTOrder::find($id);
        $brg = Product::find($dt->product_id);
        
        echo json_encode(array_merge(json_decode($dt, true), json_decode($brg, true)));
    }
    
    public function simpanEditDetail(Request $request, $id){
        $dt  = DTOrder::find($id);
        $ord = $dt->order_id;
        
        $dt->disc   = $request['disc1'];
        $dt->qty    = $request['qty'];
        $dt->update();
        
        $aa = DTOrder::where('order_id', $ord)->get();
        $tl=0;
        foreach($aa as $dd)
        {
            $tl += ($dd->qty*$dd->harga)-($dd->qty * $dd->harga *$dd->disc/100);
        }
        
        $oo = MSOrder::find($ord);
        $ttl = $tl - ($tl * $oo->order_disc/100);
        $oo->order_total = $ttl;
        $oo->update();
        
        echo json_encode(['msg'=>'success']);        
        
    }
    
    public function posting($id){
        $ord = MSOrder::find($id);
        $ord->order_status = 1;
        $ord->update();
        
        echo json_encode(['msg'=>'success']);
    }

}
