<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Redirect;
use App\Product;
use App\Supplier;
use App\Pricelist;
use App\User_logs;
use Datatables;
use DB;
use Auth;


class PricelistDetailController extends Controller
{
   public function index()
   {
	  $supplier = Supplier::all();
	  
      return view('pricelist_detail.index', compact('supplier')); 
   }

    function getdata()
    {
     	 $pricelist = Pricelist::leftJoin('ms_barang', 'pricelist.sku_id', '=', 'ms_barang.id_sku');
							//	->leftJoin('ms_supp', 'pricelist.sup_id', '=', 'ms_supp.id_supp');
								//->orderBy('pricelist.sup_id');
	 
		return Datatables::of($pricelist)->make(true);
    }
	
   public function store(Request $request)
   {
      $supplier = new Supplier;
	  $supplier->sup_id		= $request['kode'];
      $supplier->sup_nama   = $request['nama'];
      $supplier->sup_alamat = $request['alamat'];
      $supplier->sup_telp = $request['telpon'];
	  
      $supplier->save();

   }
   
   public function baru($id)
   {
		$supplier = Supplier::find($id);
		session(['idsupp'=>$supplier->id_supp]);
		session(['kdsupp'=>$supplier->sup_id]);
		
		return Redirect::route('pricelist_detail.index');  
   }
   
   public function edit($id)
   {
     $supplier = Supplier::find($id);
     echo json_encode($supplier);
   }

   public function update(Request $request, $id)
   {
      $supplier = Supplier::find($id);
      $supplier->sup_nama = $request['nama'];
      $supplier->sup_alamat = $request['alamat'];
      $supplier->sup_telp = $request['telpon'];
      $supplier->update();
   }

   public function destroy($id)
   {
      $supplier = Supplier::find($id);
      $supplier->delete();
   }
}
