<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\Referensi;
use App\Komisi;
use App\ProjectRumah;
use App\MSRumah;
use App\Transaksi;
use App\User;
use App\User_logs;
use DataTables;


class ReferensiController extends Controller
{
    public function index()
    {
		return view('referensi.index'); 
    }

    public function listData(){
     
        $dt = Referensi::orderBy('nama')
					->get();
   
        $data = [];
        foreach($dt as $list){
       
            $row = [];
            $row[] = $list->nama; 
            $row[] = $list->alamat;
            $row[] = $list->nohp;
            $row[] = $list->status;

            $row[] = '<div class="btn-btn">
                <a onclick="editref('.$list->id.')" class="btn btn-flat btn-xs" style="margin-right:-5px;"><i class="fa fa-pencil"></i></a>
                <a onclick="addkomisi('.$list->id.')" class="btn btn-flat btn-xs" style="margin-right:-5px;"><i class="fa fa-money"></i></a>
                <a onclick="report('.$list->id.')" class="btn btn-flat btn-xs" style="margin-right:-5px;"><i class="fa fa-file-pdf-o"></i></a>
               </div>';
            $data[] = $row;
        }

        return response()->json(["data"=>$data]);
	 
    }

    public function store(Request $request)
    {

        $dt = new Referensi;
      
	    $dt->nama    = strtoupper($request['nama']);
        $dt->alamat  = ucwords(strtolower($request['alamat']));
        $dt->nohp    = $request['telp'];
        $dt->status  = $request['sts'];
	    $dt->user_id	    = Auth::user()->id;
        $dt->save();

        $usrnm	= Auth::user()->username;
        
        $title		= 'New Referensi';
        $content	= $request['nama'].' ditambah sebagai referensi oleh '.$usrnm;
        $userid	= Auth::user()->id;
        
        User_logs::Userlogs($title, $content, $userid);
      
        echo json_encode(array('msg'=>'success'));
    }
   
    public function show($id){
       $dt = Referensi::find($id);
       echo json_encode($dt);
    }

    public function edit($id){
       $dt = Referensi::find($id);
       echo json_encode($dt);    }

    public function update(Request $request, $id)
    {
        $dt = Referensi::find($id);
        
	    $dt->nama    = strtoupper($request['nama']);
        $dt->alamat  = ucwords(strtolower($request['alamat']));
        $dt->nohp    = $request['telp'];
        $dt->status  = $request['sts'];
	    $dt->user_id	    = Auth::user()->id;
        $dt->update();

        $usrnm	= Auth::user()->username;
        
        $title		= 'Edit Referensi';
        $content	= 'Referensi '.$request['nama'].' diedit oleh '.$usrnm;
        $userid	= Auth::user()->id;
        
        User_logs::Userlogs($title, $content, $userid);
      
        echo json_encode(array('msg'=>'success'));
    }
   
/* komisi */
    function datakomisi($id){
        
        $kms = Komisi::with('get_transaksi')
                        ->where('ref_id', $id)
                        ->get();
        
        $data=[];                
        foreach($kms as $dt){
            
            $rmh = MSRumah::detailrumah($dt->get_transaksi->rumah_id);
            
            $row=[];
            $row[]=tanggal_indonesia($dt->tanggal, false);
            $row[]=$dt->get_transaksi->trans_no;
            $row[]=$rmh;
            $row[]='<div class="text-right">'.format_uang($dt->nominal).'&nbsp;&nbsp;&nbsp;&nbsp;</div';
            $row[]=$dt->deskripsi;
            
            $data[]=$row;
        }
        
        echo json_encode(['data'=>$data]);
                        
    }

    function daftarTrans($id){
    
        $trx = Transaksi::with('get_project', 'get_rumah')
                            ->where('ref_id', $id)
                            ->get();
                        
        $data=[];
        foreach($trx as $dt){
            
            $row=[];
            $row[] = $dt->trans_no;
            $row[] = $dt->get_project->initial;
            $row[] = $dt->get_rumah->cluster;
            $row[] = $dt->get_rumah->block.'/'.$dt->get_rumah->nomor;
            $row[] = $dt->get_rumah->luasrumah.'/'.$dt->get_rumah->luastanah;
            $row[] = '<div class="text-right">'.format_uang($dt->harga_rumah).'</div>';
            $row[] = '<div class="btn-btn">
                        <a onclick="selectTransaksi('.$dt->id.')" class="btn btn-sm btn-flat"><i class="fa fa-check"></i></a>
                      </div>';

            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);        
    }
    
    function simpanKomisi(Request $request){
        
        $ref = Referensi::find($request['id2']);
        $trx= Transaksi::find($request['id_trx']);
        $prj= ProjectRumah::find($trx->project_id);
        $rmh = MSRumah::detailrumah($trx->rumah_id);
        
        $ket=$prj->project_name.' '.$rmh;
        
        $dt = new Komisi;
        
        $dt->tanggal     = $request['tglkomisi'];
        $dt->ref_id      = $request['id2'];
        $dt->trans_id    = $request['id_trx'];
        $dt->nominal     = $request['nom'];
        $dt->deskripsi   = $request['ketrg'];
        $dt->user_id     = Auth::user()->id;
       
        $dt->save();
       
        $usrnm	= Auth::user()->username;
        
        $title		= 'Fee Komisi';
        $content	= 'Fee '.$ket. ' atas nama '.$ref->nama.' sebesar '.$request['nom'].' sudah dibayar '.$usrnm;
        $userid	= Auth::user()->id;
        
        User_logs::Userlogs($title, $content, $userid);
      
        echo json_encode(array('msg'=>'success'));
        
    }
    
    
    function report($id){
        
        $ref = Referensi::find($id);
        
        $dt = DB::table('dt_transaksi as A')
                    ->select('A.ref_id','A.tgl_book','B.project_name','B.initial', 'C.cus_name','D.cluster','D.block','D.nomor')
                    ->leftjoin('ms_project as B', function($join){
                        $join->on('A.project_id', '=','B.id');
                    })
                    ->leftjoin('ms_customer as C', function($join){
                        $join->on('A.cust_id','=','C.id_cust');
                    })
                    ->leftjoin('ms_rumah as D', function($join){
                        $join->on('A.rumah_id','=','D.id');
                    })
                    ->where('A.ref_id', $id)
                    ->orderby('A.tgl_book')
                    ->get();
                    
        $no=1;
        return view('referensi.report', compact('ref','dt','no'));
    }
    
    

}
