<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use DataTables;
use App\Salesman;
use App\Area;
use App\User;

class SalesmanController extends Controller
{
    public function index()
    {
      $area = Area::all();
      return view('salesman.index', compact('area')); 
    }

    public function area()
    {
        return view('salesman.area');
    }

	public function dataArea()
	{
		$area = Area::all();
		
		return Datatables::of($area)->make(true);
	}

    public function simpanArea(Request $request)
    {
        $area = New Area;
        $area->area_name = ucwords(strtolower($request['nama']));
        $area->save();

        echo json_encode(['msg'=>'success']);
    }

    public function getData()
    {
        $sl = Salesman::with('get_area')
                        ->orderBy('sales_kode')
                        ->get();
 
        $data = [];
        foreach($sl as $list){
           
            $row = [];
            $row[] = $list->sales_kode;
            $row[] = $list->sales_name;
            $row[] = $list->get_area->area_name;
            //$row[] = format_uang($list->sales_target);
            $row[] = '<div class="btn-btn">
                   <a onclick="editForm('.$list->id.')" class="btn btn-outline-primary btn-xs"><i class="fa fa-pencil"></i></a>
                   </div>';
            $data[] = $row;
        }

        return response()->json(["data"=>$data]);
    }

    public function store(Request $request)
    {
      
        $sl = new Salesman;
	   
        $sl->sales_area   = $request['area'];
        $sl->sales_kode   = strtoupper($request['kode']);
        $sl->sales_name   = ucwords(strtolower($request['nama']));
        //$sl->sales_target = $request['target'];

        $sl->save();

        echo json_encode(array('msg'=>'success'));
    }

    public function show($id){
      
    }

    public function edit($id)
    {
        $sl = Salesman::find($id);
        echo json_encode($sl);
    }

    public function update(Request $request, $id)
    {
        $sl = Salesman::find($id);
      
        $sl->sales_area   = $request['area'];
        $sl->sales_kode   = strtoupper($request['kode']);
        $sl->sales_name   = ucwords(strtolower($request['nama']));
        //$sl->sales_target = $request['target'];
    
        $sl->update();

        echo json_encode(array('msg'=>'success'));
    }

   public function editarea($id)
   {
      $area = Area::find($id);
      echo json_encode($area);
   }

   public function simpaneditarea(Request $request, $id)
   {
      $area = Area::find($id);
      $area->area_name  = ucwords(strtolower($request['nama']));
      $area->update();

      echo json_encode(['msg'=>'success']);
   }

}
