<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Setting;
use App\Product;

class SettingController extends Controller
{
   public function index()
   {
      return view('setting.index'); 
   }

/* welcome screen */
	public function welcome(){
	    
	    $comp_init = Setting::first();
	    
	    return view('welcome', compact('comp_init'));
	}
	

   public function edit($id)
   {
     $setting = Setting::first();
     echo json_encode($setting);
   }
   
   public function show(){
       
   }

   public function update(Request $request, $id)
   {
      $setting = Setting::find($id);
      $setting->nama_company   = $request['nama'];
      $setting->alamat         = $request['alamat'];
      $setting->telepon         = $request['telepon'];
      $setting->tipe_nota         = $request['tipe_nota'];
      
      if ($request->hasFile('logo')) {
         $file = $request->file('logo');
         $nama_gambar = "logo.".$file->getClientOriginalExtension();
         $lokasi = public_path('images');

         $file->move($lokasi, $nama_gambar);
         $setting->logo         = $nama_gambar;  
      }

      if ($request->hasFile('kartu_member')) {
         $file = $request->file('kartu_member');
         $nama_gambar = "card.".$file->getClientOriginalExtension();
         $lokasi = public_path('images');

         $file->move($lokasi, $nama_gambar);
         $setting->kartu_member   = $nama_gambar;  
      }
      $setting->update();
    }
   
    public function testprinter(){
        return view('setting.testprinter');
    }
   
    public function tescetak(){

        $lebarkolom = 75;       
        $dt = Product::with('get_category')
                        ->where('supp_id',2)
                        ->get();

        $pin    = 0;
        $on_ms  = 120;
        $off_ms = 240;

        /*initial barcode */
        $barcode_h = Chr(29) . 'h' . Chr(100);                          //tinggi barcode 100
        $barcode_M = Chr(29) . "L" . Chr(10) . Chr(0);                  //margin Left 10
        $barcode_H = Chr(29) . 'H' . Chr(2);			                //posisi data dibawah barcode
        $barcode_f = Chr(29) . 'f' . Chr(0);                            //type font
        $barcode_k = Chr(29) . 'k' . Chr(2) . '123456789012' . Chr(0);	//data dan type barocde 2=EAN13
        $barcode_L = Chr(29) . "L" . Chr(0) . Chr(0);                   //set margin ke posisi awal

        
        $bold1      = Chr(27) . Chr(69);
        $bold0      = Chr(27) . Chr(70);
        $initialized= chr(27) . chr(64);
        $condensed1 = chr(15);
        $condensed0 = chr(18);
        $cut        = Chr(27) . Chr(109);   
        $pulse      = Chr(27) . "p" . chr($pin + 48) . chr($on_ms / 2) . chr($off_ms / 2);
    
        $setLeft    = chr(27) . "a" . chr(0);
        $setCenter  = chr(27) . "a" . chr(1);
        $setRight   = chr(27) . "a" . chr(2); 
    
        $fontNormal	= chr(27) . "!" . chr(0);
        $fontKecil	= chr(27) . "!" . chr(1);
        $fontTebal	= chr(27) . "!" . chr(8);
        $fontBesar	= chr(27) . "!" . chr(16);
        $fontLebar	= chr(27) . "!" . chr(32);
        $fontUline	= chr(27) . "!" . chr(128);
        $fontSans   = chr(27) . "k" . chr(1);
        $feed       = "\x0c"; 
        
        $grs=PrinterController::replicate('-',$lebarkolom);
    

        $Data  = $initialized;
        $Data .= $condensed0;

        $Data .= $fontTebal.PrinterController::center("PRODUCT LIST", $lebarkolom)."\n";
        $Data .= $grs."\n";
        $Data .= $fontKecil.$fontTebal;
        
        /*        0        1         2         3         4         5         6         7         8         9*/
        /*        123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.*/
        /*         12. 1234 123456789.123456789.123456789.123456789. 123456789.123456789. */
        $Data .= " NO. KODE Nama Barang                              CATEGORY            "."\n";
        $Data .= $grs."\n";
        
        $no = 0;
        $ttl = 0;
        
        foreach($dt as $dtl){
            $no++;
            $kd = PrinterController::strKarakter($dtl->kode_brg,4);
            $nm = PrinterController::strKarakter(substr($dtl->nama_brg,0,40),40);
            $ct = PrinterCOntroller::strKarakter($dtl->get_category->cat_name,15);
            
            $Data .=PrinterController::strAngka($no,3).". ".$kd." ".$nm." ".$ct."\n";
        }
        
        $Data .= $grs."\n\n";
        //$Data .= $fontKecil."font kecil: AbcdefgHijklmnoPQRStuvwxyz 1234567890 \n";
        //$Data .= $fontTebal."font tebal: AbcdefgHijklmnoPQRStuvwxyz 1234567890 \n";
        //$Data .= $bold1.$fontKecil."font Kecil: AbcdefgHijklmnoPQRStuvwxyz 1234567890 \n";

        $Data .= "\n\n\n";
 
        //$Data .= $barcode_h.$barcode_M.$barcode_H.$barcode_f.$barcode_k.$barcode_L."\n";
        
        //$Data .= "\x0c";
        $Data .= $feed;

        $dt = "intent:base64," . base64_encode($Data) . "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end;";
        $output = ["data"=>$dt];

        return response()->json($output);
       
    }	  
   

    public static function CekValidStatus(){
        $set = Setting::first();
        
        $validstatus=true;
        if($set->valid_until<date('Y-m-d'))
        {
            $validstatus = false;
        }
        
        return $validstatus;
    }
   
    public static function cekvalid(){
        $set = Setting::first();
        $data=["valid"=>" Valid until: ".tanggal_indonesia($set->valid_until, false)];
        
        return response()->json($data);
    }
    
    public static function HitungMasaAktif(){
        $set = Setting::first();

        $aa = $set->valid_until;
        $bb = date('Y-m-d');

        $tgl1 = strtotime($bb); 
        $tgl2 = strtotime($aa); 
        
        $jarak = $tgl2 - $tgl1;
        $hari = $jarak / 60 / 60 / 24;

        return $hari;
    }    
    
    public function perpanjang(){
        return view('setting.index_renew');
    }
    
    public function renew(Request $request){
        
        $set = Setting::first();
        $set->valid_until = $request['masa'];
        $set->update();
        
        echo json_encode(['msg'=>'success']);
    }

}