<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\ProjectRumah;
use App\Transaksi;
use App\MSRumah;
use App\Customer;
use App\Termin;
use App\User;
use App\User_logs;
use DataTables;


class TerminController extends Controller
{
   public function index()
   {
 
   }

    public function datarumah($id){
        
        $dt = Transaksi::where('rumah_id',$id)->first();
        $prj= ProjectRumah::find($dt->project_id);
        $rmh= MSRumah::find($id);
        $cus= Customer::find($dt->cust_id);

        $data=["id_prj"=>$prj->id, "id_cust"=>$cus->id_cust, "id_rumah"=>$rmh->id, "id"=>$dt->id, "cluster"=>$rmh->cluster, "block"=>$rmh->block,
                "nomor"=>$rmh->nomor, "luastanah"=>$rmh->luastanah, "luasrumah"=>$rmh->luasrumah, "harga_rumah"=>$dt->harga_rumah,
                "total_dp"=>$dt->total_dp, "status_trx"=>$dt->status_trx, "ref_id"=>$dt->ref_id, "deskripsi"=>$dt->deskripsi,
                "project_name"=>$prj->project_name, "cus_name"=>$cus->cus_name, "address"=>$cus->cus_address, "trans_no"=>$dt->trans_no,
                "total_cicilan"=>$dt->total_cicilan,"sisa"=>$dt->harga_rumah-$dt->total_cicilan, "tgl_book"=>$dt->tgl_book];
        
        echo json_encode($data);
        

    }
    

    public function data($id) {
        
        $tr = Transaksi::where('rumah_id', $id)
                            ->first();
                            
        $dt = Termin::where('rumah_id', $id)
                    ->orderBy('tgl_cair')
                    ->get();
                
        $data = [];
        $no=1;
        $tl=0;
        foreach($dt as $list){
       
            $tl += $list->nominal;
            
            $row = [];
            $row[] = $no++; 
            $row[] = $list->tgl_cair;
            $row[] = $list->persentase;
            $row[] = '<div class="text-right">'.format_uang($list->nominal).'&nbsp;&nbsp;&nbsp;</div>';
            $row[] = $list->bank;
            $row[] = $list->deskripsi;
            
            $data[] = $row;
        }
        $row=[];
        $row[]='';
        $row[]='Sisa';
        $row[]='';
        $row[]= '<div class="text-right">'.format_uang($tr->harga_rumah-$tl).'&nbsp;&nbsp;&nbsp;</div>';
        $row[]='';
        $row[]='';
        
        $data[]=$row;
        
        return response()->json(['data'=>$data]);
	 
   }

   public function store(Request $request)
   {

        $dt = new Termin;
      
        $dt->rumah_id   = $request['idrmh2'];
        $dt->tgl_cair   = $request['tgl'];
        $dt->persentase = $request['persen'];
        $dt->nominal    = $request['nom'];
        $dt->bank       = $request['bank'];
        $dt->deskripsi  = $request['ket'];
	    $dt->user_id	= Auth::user()->id;
        $dt->save();

        echo json_encode(array('msg'=>'success'));
   }
   
   public function show($id){
 
   }

   public function edit($id)
   {

   }

   public function update(Request $request, $id)
   {

   }
   

}
