<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\Cabang;
use App\Transfer;
use App\TransferDetail;
use App\Stock;
use App\User_logs;
use Datatables;
use DB;
use Auth;
Use Redirect;

class TransferDetailController extends Controller
{

	public function index()
	{
		return view('transfer_detail.index');
	}
	
   public function listData()
   {
		$mtrf		= Transfer::find(session('idtrf'));
		
		$dtransfer	= TransferDetail::leftJoin('ms_product', 'dt_transfer.product_id', '=', 'ms_product.id')
										->where('dt_transfer.transfer_id', session('idtrf'))->get();
										
				
		$no=0;
		$totalqty	= 0;
		$data = array();
				
		foreach($dtransfer as $list){
			$no++;

			$row = array();
				
			$row[] = $no;
			$row[] = $list->nama_brg;
			$row[] = $list->no_seri;			
			$row[] = '<div class="text" align="right">'.format_uang($list->harga_retail).'</div>';
			$row[] = '<div class="text" align="right">'.format_uang($list->trf_qty).'</div>';
			$row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id_trf.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a>
					<a onclick="deleteItem('.$list->id_trf.')" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
					</div>';

            $totalqty += $list->opn_qty;
            
			$data[] = $row;		

			}
		
		$tlqty='<div class="text" align="right">'.format_uang($totalqty).'</div>';

		$output = array("data" => $data);
		return response()->json($output);
	}
			
/*--------------------------------------------------------------------*/
   public function listData2()
   {
		$minv	= Invoice::find(session('idinv'));
		
		$ppn	= $minv->inv_ppn;
		$disc1	= $minv->inv_disc;
			
		$dtinvoice	= InvoiceDetail::leftJoin('ms_product', 'dt_invoice.id_brg', '=', 'ms_product.id')
										->where('dt_invoice.invoice_id', session('idinv'))->get();
										
				
		$no=0;
		$totalinv1	= 0;
		$totalinv	= 0;
		$disc1	 	= 0;
		$disc2		= 0;
		$disc3		= 0;
			
		$last_no	= 0;
		$data = array();
				
		foreach($dtinvoice as $list){
			$no++;
			$jlh 	= $list->inv_gross*$list->inv_qty;
			$disc1	= $jlh *$list->inv_disc1/100;
			$jumlahinv	= $jlh - $disc1;
			
			$row = array();
				
			$row[] = $no;
			$row[] = $list->kode_brg;
			$row[] = $list->nama_brg;
			$row[] = $list->no_seri;			
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_gross).'</div>';
			$row[] = $list->inv_qty.' '.$list->inv_stn;
			$row[] = $list->inv_disc1;
			$row[] = '<div class="text" align="right">'.format_uang($jumlahinv).'</div>';
			$row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id_inv.')" class="btn btn-primary btn-sm"><i class="fa fa-eye"> detail </i></a>
					</div>';

			$totalinv1 += $list->inv_gross * $list->inv_qty;
						
			$totalinv = $totalinv1;	
							
			$data[] = $row;		

			}
				
		$no++;
		$data[] = array($no,"","","","<span class='hide totalopn'>$totalinv</span>", "<span class='hide totalqty'>$totalqty</span>", "", "","");
				
		$output = array("data" => $data);
		return response()->json($output);
	}
			

    public function loadSummary($id){
        
		$dtransfer	= TransferDetail::where('transfer_id', $id)->get();
		
		$totalqty=0;
										
        foreach($dtopn as $list){
            $totalopn += $list->harga_retail * $list->opn_qty;
            $totalqty += $list->opn_qty;
        }
        
        $data = array("totalqty"=>format_uang($totalqty),
                      "totalrp" =>format_uang($totalopn));
                      
        return response()->json($data);
    }
////////////////////////////////////////////////////////////////////////

 
///-- add item ----------------------------------------------------- yg sebelumnya */
	public function store(Request $request)
	{
	    $mtrf		= Transfer::find(session('idtrf'));
		$idtrf		= $mtrf->id_transfer;
		$id_to      = $mtrf->to_id;
		
		$idstock	= $request['kode'];
		$stock		= Stock::find($idstock);
		$idbrg		= $stock->product_id;
		$noseri		= $stock->no_seri;
		
		$product	= Product::find($idbrg);
		
/*  tidak perlu *	
	$ada_trf	= TransferDetail::where('transfer_id',$idtrf)
									->where('product_id', $idstock)
									->where('no_seri', $noseri)
									->count();
		
		if ($ada_trf>0)
		{
			echo json_encode(array('msg'=>'error'));
		}
*/		
		$trfdetail	= New TransferDetail;
		$trfdetail->transfer_id	= $idtrf;
		$trfdetail->product_id	= $idbrg;
		$trfdetail->no_seri		= $noseri;
		$trfdetail->trf_retail	= $product->harga_retail;
		$trfdetail->trf_qty		= 1;		//default qty
	
		$trfdetail->user_id	= Auth::user()->id;
		
		$trfdetail->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Transfer Detail '.$mtrf->trf_no;
			$userlog->content	= $product->nama_brg.' No.Seri '.$noseri.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}
	

/*----------------------------------------------------------------*/
	public function store__(Request $request)
	{
		$idinv		= $request['id_inv'];
		$idlist		= $request['idbrg'];
		$serial		= $request['noseri_'];
		$disc1		= $request['disc1_'];
		$qty		= $request['qty_'];
		
		$product	= Product::find($idlist);
		$kode		= $product->kode_brg;
			
		//$ada_inv	= InvoiceDetail::where('invoice_id',$idinv)
		//							->where('id_brg', $idlist)
		//							->where('no_seri', $serial)
		//							->count();
		
		//if ($ada_inv>0)
		//{
		//	echo json_encode(array('msg'=>'error'));
		//}
		
		$invdetail	= New InvoiceDetail;
		
		$invdetail->invoice_id	= $idinv;
		$invdetail->id_brg		= $product->id;
		$invdetail->inv_gross	= $product->harga_list;
		$invdetail->inv_qty		= $qty;			//default qty
		$invdetail->inv_disc1	= $disc1;		//default disc1
		$invdetail->no_seri		= $serial;
		$invdetail->inv_stn		= "PCS";

		$invdetail->user_id	= Auth::user()->id;
		
		$invdetail->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Input detail Invoice';
			$userlog->content	= 'KODE '.$kode.' berhasil ditambahkan oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
			       			
	}


/*-------------------------------------------------------------------*/
	public function show($id)
	{
		//$dtinv = InvoiceDetail::find($id);
		$barang = Product::find($id);
	 
		echo json_encode($barang);		
	}
	
    public function edit($id)
    {
      $dttrf = TransferDetail::find($id);
	  $barang = Product::find($dttrf->product_id);
	 
	  echo json_encode(array_merge(json_decode($barang, true),json_decode($dttrf, true)));
	
    }

    public function caribrg($id)
    {
	  $barang = Product::find($id);
	 
	  echo json_encode($barang);
    }
////////////////
	
    public function update(Request $request, $id)		
    {
		$dttrf 		= TransferDetail::find($id);
		$product	= Product::find($dttrf->product_id);
		$mtrf		= Transfer::find($dttrf->transfer_id);
		
		$dttrf->trf_qty 	= $request['qty'];
		$dttrf->user_id	 	= Auth::user()->id; 
 
		$dttrf->update();
		
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Edit QTY Transfer '.$mtrf->trf_no;
		$userlog->content	=  $product->nama_brg.' No Seri. '.$dttrf->no_seri.' QTY='.$request['qty'].' by. '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		

        echo json_encode(array('msg'=>'success'));
    }

   public function destroy($id)
   {
		$dtopn = StockOpnameDetail::find($id);
	  
		$dtopn->delete(); 
   }
	
	public function printForm()
	{
		
		$mopn		= StockOpname::find(session('idopn'));
		
		$dopn	 	= StockOpnameDetail::leftjoin('ms_product', 'dt_opname.product_id', 'ms_product.id')
									->where('dt_opname.opname_id', '=', session('idopn'))
									->get();
		$tlqty=0;
		$tlval=0;
		
		foreach($dopn as $list){
			$tlqty += $list->opn_qty;
			$tlval += ($list->opn_qty * $list->harga_retail);
		}

		$cabang	= Cabang::find($mopn->cabang_id);
		$no 	= 1;
     
	 	return view('stockopname_detail.printopn', compact('mopn','dopn','no','cabang', 'tlqty', 'tlval')); 
   } 	
   
/*  reprint po */
	public function reprintForm()
	{
		
		$minv		= Invoice::find(session('idinv'));
		
		$dinv	 	= InvoiceDetail::leftjoin('ms_product', 'dt_invoice.id_brg', 'ms_product.id')
									->where('dt_invoice.invoice_id', '=', session('idinv'))
									->get();
								
									
		$supplier	= Supplier::find($minv->supp_id);

		$no 		= 1;

	 	return view('invoice_detail.reprintinv', compact('minv','dinv','no','supplier')); 
   } 	   
   
/*  histore */
   public function historyData()
   {
		$mtrf		= Transfer::find(session('idtrf'));
		
		$dtransfer	= TransferDetail::leftJoin('ms_product', 'dt_transfer.product_id', '=', 'ms_product.id')
										->where('dt_transfer.transfer_id', session('idtrf'))->get();
										
				
		$no=0;
		$totalqty	= 0;
		$data = array();
				
		foreach($dtransfer as $list){
			$no++;

			$row = array();
				
			$row[] = $no;
			$row[] = $list->nama_brg;
			$row[] = $list->no_seri;			
			$row[] = '<div class="text" align="right">'.format_uang($list->harga_retail).'</div>';
			$row[] = '<div class="text" align="right">'.format_uang($list->trf_qty).'</div>';
            
			$data[] = $row;		

			}

		$output = array("data" => $data);
		return response()->json($output);
	}
			   
	
}	
