<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\User_logs;
use Auth;
use Hash;

class UserController extends Controller
{
   public function index()
   {
      return view('user.index'); 
   }

   public function listData()
   {
   
     $user = User::where('level', '=', 1)
                    ->orderBy('users.id', 'desc')->get();
     $no = 0;
     $data = array();
     foreach($user as $list){
       $no ++;
       $row = array();
       $row[] = $no ;
       $row[] = $list->username;
       $row[] = $list->group;
       $row[] = '<div class="btn-btn">
					<a onclick="editForm('.$list->id.') " class="btn btn-outline-primary btn-xs"><i class="fa fa-pencil"></i></a> </div>';
				
       $data[] = $row;
     }

     $output = array("data" => $data);
     return response()->json($output);
   }

   public function store(Request $request)
   {
      $user = new User;
      $user->username 	= $request['nama'];
      $user->email 		= $request['email'];
      $user->password	= bcrypt($request['password']);
    
	//  $user->remember_token	= "";
	 
      $user->level 		= 1;
	   $user->group		= $request['group'];
      $user->foto 		= "user.png";
      $user->save();
// insert logs
		$userid	= $request['nama'];
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title		= 'Tambah User';
		$userlog->content	= 'User baru '.$userid.' berhasil ditambah oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();		
	  
	    echo json_encode(array('msg'=>'success')); 
   }

   public function edit($id)
   {
     $user = User::find($id);
     echo json_encode($user);
   }

   public function update(Request $request, $id)
   {
      $user = User::find($id);
      $user->username 	= $request['nama'];
      $user->email 		= $request['email'];
	   $user->group		= $request['group'];
	   	  
      if(!empty($request['password'])) $user->password = bcrypt($request['password']);
      $user->update();
	  
	   echo json_encode(array('msg'=>'success')); 
   }

   public function destroy($id)
   {
      $user = User::find($id);
      $user->delete();
   }

   public function profil()
   {
      $user = Auth::user();
      return view('user.profil', compact('user')); 
   }

   public function changeProfil(Request $request, $id)
   {
      $msg = "succcess";
      $user = User::find($id);
      if(!empty($request['password'])){
        if(Hash::check($request['passwordlama'], $user->password)){
         $user->password = bcrypt($request['password']);
        }else{
         $msg = 'error';
        }
      } 

      if ($request->hasFile('foto')) {
         $file = $request->file('foto');
         $nama_gambar = "fotouser_".$id.".".$file->getClientOriginalExtension();
         $lokasi = public_path('images');

         $file->move($lokasi, $nama_gambar);
         $user->foto         = $nama_gambar;  
         
         $datagambar = $nama_gambar;
      }else{
         $datagambar = $user->foto; 
      }

      $user->update();
      echo json_encode(array('msg'=>$msg, 'url'=> asset('public/images/'.$datagambar))); 
   }
}
