<?php


namespace App\Imports;

use App\DTKas;


use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Imports\HeadingRowFormatter;

class BiayaImport implements ToModel, WithHeadingRow, WithBatchInserts, WithChunkReading
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        ini_set('max_execution_time', 1500); //7 minutes

		$dt = New DTKas;

 		$dt->kas_id     = $row['kas'];
 		$dt->project_id = $row['prj'];
 		$dt->no_acct    = $row['noacct'];
 		$dt->is_cb      = $row['iscb'];
 		$dt->is_dk      = $row['isdk'];
 		$dt->tanggal    = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['tanggal']);
 		$dt->nominal    = $row['nominal'];
 		$dt->deskripsi  = $row['deskripsi'];
 		
		$dt->save();
		
    }
    
    
    public function batchSize(): int
    {
        return 500;
    }
    
    public function chunkSize(): int
    {
        return 500;
    }
	
	
}
