<head>

</head>

@extends('layouts.app')

@section('title')

@endsection

@section('breadcrumb')
   @parent
   <li>Transaksi Penjualan</li>
@endsection


@section('content')   
<div class="row">
	<div class="container-fluid">
		<div class="card">
			<div class="card-block">  
			
    <a onclick="addForm()" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"> </i> New Kas </a> 			
    
<form method="post" id="form-biaya">
{{ csrf_field() }}

<input type="hidden" id="mgr" name ="mgr" value="{{ Auth::user()->group }}"> 
<input type="hidden" id="idbiaya" name="idbiaya">

<table class="table table-hover table-striped table-bordered" id="tbltrans" width="100%">
<thead>
    <tr class="tblheader">
        <th width="40px">PRJ</th>   
        <th width="100px">Periode</th>
        <th width="100px">Kasir</th>
        <th width="50px">Tipe</th>
        <th width="100px">Account</th>
        <th class="text-center" width="100px">Saldo Awal</th>
        <th class="text-center" width="100px">Kas Masuk</th>
        <th class="text-center" width="100px">Biaya</th>
        <th class="text-center" width="100px">Saldo</th>
        <!--th width="150px">Keterangan</th-->
        <th class="text-center" width="30px">Act</th>
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>

@include('biaya.kas_create')
@include('biaya.kas_input')
@include('biaya.form_biaya')
@include('biaya.add_biaya')


@endsection

@section('script')
<script type="text/javascript">
var table, save_method;

$(function(){
    table = $('#tbltrans').DataTable({
        "processing" : true,
        "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       //pilihan jumlah record show
        "order" : [0,'DESC'],
        "dom": "bftip",
        "ajax" : {
            "url" : "{{ route('biaya.datakas') }}",
            "type" : "GET"
        }
    }); 
});   

//submit create
$('#form-create').validator().on("submit", function(e) {

    if(!e.isDefaultPrevented()){
		 
		$('#submit-control').html(' Simpan Create ... ');
		$('#submit-control').attr('disabled','disabled');
		  
        var id = $('#id').val();
        if(save_method == "add") { url = "{{ route('biaya.store') }}"; }
        else { url = "{{ DIR_APP }}biaya/"+id; }

        $.ajax({
            url : url,
            type : "POST",
            data : $('#form-create').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#masa').focus().select();
				}else{
					$('#modal-form_create').modal('hide');
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');		
					$('#tbltrans').DataTable().ajax.reload(null, false);
				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			    $('#submit-control').html('Save');
			    $('#submit-control').removeAttr('disabled');			 
            }   
        });
        return false;
	}
});
   

function addForm(){
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#modal-form_create').modal('show');
    $('#modal-form_create form')[0].reset();     
} 	 

function addKas(id){
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#modal-kasmasuk').modal('show');
    $('#modal-kasmasuk form')[0].reset();     
    
    $('#idkas').val(id);
}    

//submit
$('#form-kasmasuk').validator().on("submit", function(e) {

    if(!e.isDefaultPrevented()){
		 
		$('#submit-kas').html(' Simpan Create ... ');
		$('#submit-kas').attr('disabled','disabled');
		  
        var id = $('#idkas').val();
        if(save_method == "add") { url = "{{ route('biaya.kasmasuk') }}"; }
        else { url = "{{ DIR_APP }}biaya/"+id; }

        $.ajax({
            url : url,
            type : "POST",
            data : $('#form-kasmasuk').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="errorperiode"){
					$('#submit-kas').html('Save');
					$('#submit-kas').removeAttr('disabled');
					swal("WARNING", " Periode tgl salah !","error");
					$('#tglkas').focus().select();
				}else{
					$('#modal-kasmasuk').modal('hide');
					$('#submit-kas').html('Save');
					$('#submit-kas').removeAttr('disabled');		
					$('#tbltrans').DataTable().ajax.reload(null, false);
				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			    $('#submit-kas').html('Save');
			    $('#submit-kas').removeAttr('disabled');			 
            }   
        });
        return false;
	}
});
   

function addBiaya(id){
    $('#modal-biaya').modal('show');
    $('#idtrx').val(id);
    tampilKeterangan(id);
    tampilDetail(id);
}

function tampilDetail(id){

    tblbiaya.ajax.url("{{ DIR_APP }}biaya/"+id+"/databiaya");
	tblbiaya.ajax.reload();

    hitungSaldo(id);
}    

tblbiaya = $('#tbl-biaya').DataTable({
    "scrollY": '55vh',
    "scrollCollapse": true,
    "bSort": false,
    "destroy": true,
    "processing" : true,
    "paging" : false,
    "dom" : 'bfti',
});

tblmasuk = $('#tbl-masuk').DataTable({
    "scrollY": '10vh',
    "scrollCollapse": true,
    "bSort": false,
    "destroy": true,
    "processing" : true,
    "paging" : false,
    "dom" : 'bt',
});


function tampilKeterangan(id){
    $.ajax({
        url : "{{ DIR_APP }}biaya/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){

	        $('#ketr').text(data.acct_name);
	 
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });       
}


function editinfo(id){
    save_method = "edit";

    $('input[name=_method]').val('PATCH');
    $('#modal-form_create form')[0].reset();
    $('#modal-form_create').modal('show');   
    $('#id').val(id);
    
    $.ajax({
        url : "{{ DIR_APP }}transaksi/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){

            $('#prj').val(data.id_prj).attr('disabled', 'disabled');
            $('#cus').val(data.id_cust).attr('disabled', 'disabled');
            $('#tipe').val(data.luasrumah. concat('/', data.luastanah)).attr('disabled', 'disabled');
	        $('#nomor').val(data.cluster. concat('/', data.block. concat('/', data.nomor))).attr('disabled', 'disabled');
	        $('#harga').val(formatAngka(data.harga_rumah));
	        $('#byr').val(data.status_trx);
	        $('#dp').val(data.total_dp).attr('disabled', 'disabled');
	        $('#ref').val(data.referensi);
	        $('#ket').val(data.deskripsi);
	        
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}

function formatAngka(x) {
    x = x.toString();
    var pattern = /(-?\d+)(\d{3})/;
    while (pattern.test(x))
        x = x.replace(pattern, "$1.$2");
    return x;
}

/* input biaya */
function biaya(){
    var id=$('#idtrx').val();
    
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#modal-addbiaya').modal('show');
    $('#modal-addbiaya form')[0].reset();     
    
    $('#id2').val(id);
    
} 

/* input biaya */
function editdata(id){

    save_method = "edit";
    $('input[name=_method]').val('PATCH');
    $('#modal-addbiaya').modal('show');
    $('#modal-addbiaya form')[0].reset();     
    
    $('#id2').val(id);

    $.ajax({
        url : "{{ DIR_APP }}biaya/"+id+"/editbiaya",
        type : "GET",
        dataType : "JSON",
        success : function(data){

	        $('#tgl2').val(data.tanggal);
	        $('#act2').val(data.id2);
	        $('#project').val(data.project_id);
	        $('#biaya').val(data.nominal);
	        $('#ketr2').val(data.deskripsi);
	 
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });        
    
}


//submit
$('#form-addbiaya').validator().on("submit", function(e) {

    if(!e.isDefaultPrevented()){
        
        var id = $('#id2').val();		 
        if(save_method == "add") { url = "{{ route('biaya.simpanbiaya') }}"; tipe="POST"; }
        else { url="{{ DIR_APP }}biaya/"+id+"/simpaneditbiaya"; tipe="GET"; }

        $.ajax({
            url : url,
            type : tipe,
            data : $('#form-addbiaya').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="error"){
					swal("WARNING", " Gagal menyimpan data/ type Account salah !","error");

				}else{

					$('#modal-addbiaya').modal('hide');
					$('#tbl-biaya').DataTable().ajax.reload(null, false);
					$('#tbltrans').DataTable().ajax.reload(null, false);
					
					hitungSaldo(id);
				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
		 
            }   
        });
        return false;
	}
});


function hitungSaldo(id){

    $.ajax({
        url : "{{ DIR_APP }}biaya/"+id+"/hitungsaldo",
        type : "GET",
        dataType : "JSON",
        success : function(data){

	        $('#sisa').text("SALDO : "+data.saldo);

	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });        
    
}



function printBiaya(id){
    window.location="{{ DIR_APP }}biaya/"+id+"/printrekap";
} 

function reportBiaya(){
    var id=$('#idtrx').val();
    window.location="{{ DIR_APP }}biaya/"+id+"/printrekap";
} 


/* posting: data tidak bisa diedit lagi   */

function closingBiaya(id){

    swal({
        title: "Anda Yakin ingin Closing Kas ?",
        text: "Data tidak bisa diedit lagi jika sudah diclosing, saldo Akhir jadi saldo Awal periode berikutnya !",
        icon: "info",
        buttons: [
            'Batal',
            'Closing'
            ],
        dangerMode: true,
        }).then(function(isConfirm) {
        if (isConfirm) {
            swal({
                title: 'Confirm!',
                text: 'Klik OK untuk melanjutkan Closing !',
                icon: 'info'
            }).then(function() {
                closing(id);
            });
        }else {
            swal("Batal", "Kas masih bisa diedit :)", "error");
        }
    })
}    

function closing(id){
    
    $('#idbiaya').val(id);
    
    $.ajax({
        url : "{{ DIR_APP }}biaya/posting",
        type : "POST",
        data : $('#form-biaya').serialize(),
        dataType: 'JSON',		   
        success : function(data){
		    if(data.msg=="error"){
				swal("WARNING", " Gagal closing data !","error");
				
			}else{
                swal("Success", "Data berhasil diclosing !", "success");
                location.reload();
			}   
	    },
        error : function(){
		    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
        }   
    });
    return false;
}



</script>


@endsection
