@extends('layouts.app')

@section('title')
  Master Category
    
@endsection

@section('breadcrumb')
   @parent
   <li>category</li>
@endsection


@section('content')   
<section id="tbl-data" class="show">

<div class="row">
  <div class="container">
    <div class="card">
       <div class="card-block">       

      <div class="text-left">
      <a onclick="addForm()" class="btn btn-outline-info btn-sm"><i class="fa fa-plus-circle"></i> New Category </a>
      </div>

<table class="table table-bordered table-hover" id="category" width="100%">
  <thead>
    <tr class="tblheader">
        <th width="75%">Nama Category</th>
        <th width="15%">Opsi</th>
    </tr>
  </thead>
  <tbody></tbody>
</table>

      </div>
    </div>
  </div>
</div>
</section>

<!-----form input -----------------> 
<section id="form-data" class="hide">

<form class="form-horizontal" data-toggle="validator" method="post" id="form-input">
    {{ csrf_field() }} {{ method_field('POST') }}
   
    <div class="card" style="width:100%; margin:auto; padding:10px 50px;">
        <div class="card-block">
            <h5>Form Category</h5>
    <br></br>
    <input type="hidden" id="id" name="id">


    <div class="form-group">
        <div class="col-sm-10 col-md-10">
            <label for="nama" class="control-label">Nama Category</label>
            <input id="nama" type="text" class="form-control" name="nama" autofocus required autocomplete="off">
            <span class="help-block with-errors"></span>
        </div>
    </div>
    <br></br>

    <div class="card-body">
	    <button id="submit-control" type="submit" class="btn btn-outline-success"><i class="fa fa-floppy-o"></i> Simpan </button>
		<button id="tutup" type="button" onclick="tutupForm()" class="btn btn-outline-warning"><i class="fa fa-times"></i> Close</button>
    </div>
    
        </div>
    </div>

   </form>

</section>

@endsection

@section('script')
<script type="text/javascript">
var  save_method;
$(document).ready(function() {

	var table = $('#category').DataTable ({
        "processing": true,
        "serverSide": true,
        "ajax": "{{ route('category.getdata') }}",
        "columns":[
            { "data": "cat_name" },
			      {
                "data": "id_cat",
                "sClass": "text-center",
                "orderable": false,
                "mRender": function (data) {
                           return '<a onclick="editForm('+data+')" class="btn btn-outline-success btn-xs"><i class="fa fa-pencil"></i></a> ' 
                         }
            }
  			
        ]
     });
   
   $('#form-input').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){
		  $('#submit-control').html(' data sedang disimpan ... ');
		  $('#submit-control').attr('disabled','disabled');		  

      var id = $('#id').val();
      if(save_method == "add") url = "{{ route('category.store') }}";
      else url = "category/"+id;
         
      $.ajax({
          url : url,
          type : "POST",
          data : $('#form-input').serialize(),
          dataType :"JSON",
          success : function(data){

          if(data.msg =="error"){  
              swal("WARNING", " Category gagal disimpan ! ","error"); 
          }else{
              swal("SUCCESS", " Category berhasil disimpan ! ","success");
			        $('#submit-control').html('<i class="fa fa-floppy-o"></i> Save');
			        $('#submit-control').removeAttr('disabled');	
              tutupForm();
              $('#category').DataTable().ajax.reload(null, false);
            }
          },
          error : function(){
            $('#submit-control').html('<i class="fa fa-floppy-o"></i> Save');
			      $('#submit-control').removeAttr('disabled');
            alert("Tidak dapat menyimpan data!");
          }   
      });
         return false;
     }
	  
   });
   
});

function add_Form(){
	save_method = "add";
	$('input[name=_method]').val('POST');
	$('#modal-form').modal('show');
	$('#modal-form form')[0].reset();   

	$('.modal-title').text('New Category');
}

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $.ajax({
     url : "category/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){

       bukaForm();
       
       $('#id').val(data.id_cat);
       $('#nama').val(data.cat_name);
       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

/* versi baru */

function addForm(){
	save_method="add";
    $('input[name=_method]').val('POST');

  
	$('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}


function tutupForm(){
  
	$('#form-data').addClass("hide");
	$('#tbl-data').removeClass("hide");
	$('#tbl-data').addClass("show");	

  document.getElementById("form-input").reset();
}

function bukaForm(){
  
    $('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}

</script>
@endsection