<head>
    <style>
        #tbl-customer th, tr, td {border-bottom:1px black solid; border-top:1px black solid; }
    </style>
</head>

@extends('layouts.app')

@section('title')
  Master Customer
@endsection

@section('breadcrumb')
   @parent
   <li>customer</li>
@endsection

@section('content')     

<section id="tbl-data" class="show">

<div class="row">
  <div class="container">
    <div class="card">
      <div class="card-block">     

      <div class="text-left">
        <a onclick="addForm()" class="btn btn-outline-info btn-sm"><i class="fa fa-user" ></i> New Customer</a>
        <a onclick="printcust()" class="btn btn-outline-info btn-sm"><i class="fa fa-print" ></i> Print Customer</a>
        <a onclick="printcalon()" class="btn btn-outline-info btn-sm"><i class="fa fa-print" ></i> Print Calon Cutomer</a>
      </div>

<table class="table table-striped table-padding table-responsive" id="tbl-customer" width="100%">
<thead>
   <tr class="tblheader">
      <th width="20%">Nama</th>
      <th width="30%">Alamat</th>
	  <th width="10%">No.HP</th>
	  <th width="10%">STATUS</th>
	  <th width="25%">Catatan</th>
      <th width="8%">Act</th>
   </tr>
</thead>
<tbody></tbody>
</table>

      </div>
    </div>
  </div>
</div>
</section>

<!---------------------------- form data ------------------------> 

<setcion id="form-data" class="hide">

<form class="form-horizontal" data-toggle="validator" method="post" id="form-input">
   {{ csrf_field() }} {{ method_field('POST') }}
   
<div class="Container-fluid">      

    <div class="card" style="width:100%; margin:auto;">
        <div class="card-block">
            <h6>Form Customer</h6>

    <div style="padding:5px 50px">
      
    <input type="hidden" id="id" name="id">
      
    <div class="row">
        <div class="col-sm-6 col-md-6">      
            <div class="form-group">
                <label for="nama">Nama Customer</label>
                <input id="nama" type="text" class="form-control" name="nama" autofocus required autocomplete="off">
                <span class="help-block with-errors"></span>
            </div>
        
            <div class="form-group">
                <label for="alamat">Alamat</label>
                <input id="alamat" type="text" class="form-control" name="alamat" autofocus autocomplete="off" required>
                <small class="text-muted">Alamat Lengkap Customer</small>
            </div>

            <div class="form-group">
                <label for="kota">Kota</label>
                <select id="kota" type="text" class="form-control" name="kota" autofocus required>
                    <option value=""> -- Pilih Kota -- </option>
                    @foreach($kota as $list)
                      <option value="{{ $list->city_id }}">{{ $list->city_name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label>Catatan Detail</label>
                <textarea id="ket" name="ket" class="form-control" rows="5" autofocus></textarea>
                <small class="text-muted">Catatan detail tentang Customer</small>
            </div>
            
        </div>
        
        <div class="col-sm-1"></div>
        
        <div class="col-sm-5 col-md-5">
            
            <div class="form-group">
                <label for="telp">No. Telepon/HP</label>
                <input id="telp" type="text" class="form-control" name="telp" autofocus required autocomplete="off">
                <small class="text-muted">No.HP / No.Telp harus ada</small>
            </div>             
            <div class="form-group">
                <label>No. KTP</label>
                <input id="nik" type="text" class="form-control" name="nik" autofocus autocomplete="off" required>
                <small class="text-muted">No. KTP wajib diisi</small>
            </div>

            <div class="form-group">
                <label>No. NPWP</label>
                <input id="npwp" type="text" class="form-control" name="npwp" autofocus autocomplete="off">
                <small class="text-muted">No. NPWP wajib pajak</small>
            </div>
            
            <div class="form-group">
                <label>Status</label>
                <select id="sts" name="sts" type="text" class="form-control" autofocus required>
                    <option value="1">Customer</option>
                    <option value="0">Calon Customer</option>
                </select>
            </div>
            
            <div class="form-group">
                <label>Email</label>
                <input id="email" type="email" class="form-control" name="email" autofocus autocomplete="off">
                <small class="text-muted">alamat email jika ada</small>
            </div>            
            
            <div class="form-group">
        	    <button id="submit-control" type="submit" class="btn btn-outline-success"><i class="fa fa-floppy-o"></i> Save </button>
                <button id="tutup" onclick="tutupForm()" type="button" class="btn btn-outline-warning"><i class="fa fa-times"></i> Cancel</button>
            </div>            
            
        </div>
        
    </div>

    </div>
    
            </div>
        </div>
    </div>
</form>

</section>

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
$(function(){
   table = $('.table').DataTable({
     "processing" : true,
     "lengthMenu": [[6, 15, 50, -1], [6, 15, 50, "All"]],       //pilihan jumlah record show
     "ajax" : {
       "url" : "{{ route('customer.data') }}",
       "type" : "GET"
     }
   }); 
   
    $('#form-input').validator().on('submit', function(e){
      
        if(!e.isDefaultPrevented()){
            var id = $('#id').val();
            if(save_method == "add") url = "{{ route('customer.store') }}";
                else url = "customer/"+id;
         
            $.ajax({
                url : url,
                type : "POST",
                data : $('#form-input').serialize(),
                dataType: 'JSON',		   
                success : function(data){
 
                    if(data.msg=="error"){
               	        swal("WARNING", " Gagal menyimpan data !","error");
                        $('#nama').focus().select();
                    }else{
                        tutupForm();
				        swal("SUCCESS", " Master Customer berhasil disimpan ! ","success");
                        table.ajax.reload(null, false);
                    }   
 		        },
                error : function(){
		            swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");	
                }   
            });
            return false;
        }
    });
});

function addForm(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form').modal('show');
   $('#modal-form form')[0].reset();            
   $('.modal-title').text('New Customer');
}

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   
   $.ajax({
     url : "customer/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){

        bukaForm();       
        $('#id').val(data.id_cust);
	    $('#nama').val(data.cus_name);
        $('#alamat').val(data.cus_address);
        $('#kota').val(data.cus_kota);
	    $('#telp').val(data.cus_hp);
        $('#nik').val(data.cus_noid);
        $('#npwp').val(data.no_npwp);
        $('#sts').val(data.is_customer);
        $('#email').val(data.email);
        $('#ket').val(data.deskripsi);
       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

/* versi baru */

function addForm(){
	save_method="add";
    $('input[name=_method]').val('POST');

    //$('#burger').click();
	$('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}


function tutupForm(){
    //$('#burger').click();
	$('#form-data').addClass("hide");
	$('#tbl-data').removeClass("hide");
	$('#tbl-data').addClass("show");	

    document.getElementById("form-input").reset();
}

function bukaForm(){
    //$('#burger').click();
    $('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}

function printcust(){
    window.location="{{ DIR_APP }}customer/1/printdata";
}

function printcalon(){
    window.location="{{ DIR_APP }}customer/2/printdata";
}



</script>
@endsection