<head>
    <style>
        #tbl-gaji th, tr, td {border-bottom:1px black solid; border-top:1px black solid; }
    </style>
</head>

@extends('layouts.app')

@section('title')
  Master Gaji
@endsection

@section('breadcrumb')
   @parent
   <li>gaji</li>
@endsection

@section('content')     

<section id="tbl-data" class="show">

<div class="row">
  <div class="container">
    <div class="card">
      <div class="card-block">     

      <div class="text-left">
        <a onclick="addForm()" class="btn btn-outline-info btn-sm"><i class="fa fa-user" ></i> New Data</a>
      </div>

<table class="table table-striped table-padding table-responsive" id="tbl-pegawai" width="100%">
<thead>
   <tr class="tblheader">
      <th width="5%">NIP</th> 
      <th width="20%">Nama</th>
      <th width="10%">Jabatan</th>
      <th width="10%">Gaji Pokok</th>
      <th width="10%">Tunjangan</th>      
	  <th width="8%">Bonus</th>
      <th width="8%">Act</th>
   </tr>
</thead>
<tbody></tbody>
</table>

      </div>
    </div>
  </div>
</div>
</section>

<!---------------------------- form data ------------------------> 

<setcion id="form-data" class="hide">

<form class="form-horizontal" data-toggle="validator" method="post" id="form-input">
   {{ csrf_field() }} {{ method_field('POST') }}
   
<div class="Container-fluid">      

    <div class="card" style="width:100%; margin:auto;">
        <div class="card-block">
            <h6>Form Master Gaji</h6>

    <div style="padding:5px 50px">
      
        <div class="row">
        <div class="col-sm-5 col-md-5">      

            <div class="form-group">
                <label>Nama Pegawai</label>
                <select id="peg" type="text" class="form-control" name="peg" autofocus required >
                    <option value="">--- Pilih Pegaawai ---</option>
                    @foreach($dt as $pg)
                        <option value="{{ $pg->id }}">{{ $pg->nip.' - '.$pg->nama.' - '.$pg->get_jabatan->jabatan }}</option>
                    @endforeach
                </select>
            </div>
            
            <div class="form-group">
                <label>NIP</label>
                <input id="nip" type="text" class="form-control" name="nip" autofocus readonly="true">
            </div>

            <div class="form-group">
                <label>JABATAN</label>
                <input id="jbt" type="text" class="form-control" name="jbt" autofocus required readonly="true">
            </div>              
            
            <div class="form-group">
                <label>Tgl. Kerja</label>
                <input id="tglkerja" type="date" class="form-control" name="tglkerja" autofocus readonly="true">
            </div>
            
        </div>
        
        <div class="col-sm-1"></div>
        
        <div class="col-sm-6 col-md-6">

            <div class="form-group">
                <label>GAJI POKOK</label>
                <input id="gp" type="number" class="form-control" name="gp" autofocus autocomplete="off" required>
            </div>             

            <div class="form-group">
                <label>TUNJANGAN</label>
                <input id="tjg" type="number" class="form-control" name="tjg" value="0" autofocus autocomplete="off">
            </div>  

<!--
            <div class="form-group">
                <label>BONUS</label>
                <input id="bns" name="bns" type="number" class="form-control" value="0" autofocus>
            </div>
-->

            <div class="form-group">
                <label>Catatan Detail</label>
                <textarea id="ket" name="ket" class="form-control" rows="3" autofocus placeholder="belum ada catatan ..."></textarea>
                <small class="text-muted">Catatan tentang gaji ybs</small>
            </div>


            <div class="form-group">
        	    <button id="submit-control" type="submit" class="btn btn-outline-success"><i class="fa fa-floppy-o"></i> Save </button>
                <button id="tutup" onclick="tutupForm()" type="button" class="btn btn-outline-warning"><i class="fa fa-times"></i> Cancel</button>
            </div>            
            
        </div>
        
    </div>

    </div>
    
            </div>
        </div>
    </div>
</form>

</section>

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;


$(function(){
   table = $('.table').DataTable({
     "processing" : true,
     "lengthMenu": [[8, 15, 50, -1], [8, 15, 50, "All"]],       //pilihan jumlah record show
     "ajax" : {
       "url" : "{{ route('gaji.data') }}",
       "type" : "GET"
     }
   }); 
   
    $('#form-input').validator().on('submit', function(e){
      
        if(!e.isDefaultPrevented()){
            var id = $('#peg').val();
            if(save_method == "add") url = "{{ route('gaji.store') }}";
                else url = "gaji/"+id;
         
            $.ajax({
                url : url,
                type : "POST",
                data : $('#form-input').serialize(),
                dataType: 'JSON',		   
                success : function(data){
 
                    if(data.msg=="error"){
               	        swal("WARNING", " Gagal menyimpan data !","error");
                        $('#nama').focus().select();
                    }else{
                        tutupForm();
				        swal("SUCCESS", " Data Gaji berhasil disimpan ! ","success");
                        table.ajax.reload(null, false);
                    }   
 		        },
                error : function(){
		            swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");	
                }   
            });
            return false;
        }
    });
});


/* versi baru */

function addForm(){
	save_method="add";
    $('input[name=_method]').val('POST');

    //$('#burger').click();
	$('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}


function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   
   $.ajax({
     url : "gaji/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
         
        if(data.msg=='error'){
            swal('info', 'Data Gaji belum ada', 'info');
            return false;
        }

        bukaForm();       
        $('#peg').val(data.id);
        $('#jbt').val(data.jabatan);
        $('#nip').val(data.nip);
        $('#tglkerja').val(data.tgl_kerja);
        $('#gp').val(data.gaji_pokok);
        $('#tjg').val(data.tunjangan);
        $('#ket').val(data.deskripsi);
       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}


function tutupForm(){
    //$('#burger').click();
	$('#form-data').addClass("hide");
	$('#tbl-data').removeClass("hide");
	$('#tbl-data').addClass("show");	

    document.getElementById("form-input").reset();
}

function bukaForm(){
    //$('#burger').click();
    $('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}

$('#peg').on('change', function(){
    tampildata();
})


function tampildata(){
    
    var id=$('#peg').val();

   $.ajax({
     url : "{{ DIR_APP }}pegawai/"+id+"/tampilpegawai",
     type : "GET",
     dataType : "JSON",
     success : function(data){

        $('#jbt').val(data.jabatan);
        $('#nip').val(data.nip);
        $('#tglkerja').val(data.tgl_kerja);

     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}



</script>
@endsection