@extends('layouts.app')

<head>
    <style>
        #tbl-gudang th, tr, td {border-bottom:1px black solid; border-top:1px black solid; }
	</style>
</head>

@section('breadcrumb')
   @parent
   <li>gudang</li>
@endsection

@section('content')     
<div class="row">
    <div class="container-fluid">
        <div class="card">
             <div class="card-block">  

    <a onclick="addForm()" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"></i> New Gudang </a>
	<!--a onclick="window.location='{{ route('home') }}'" class="btn btn-warning btn-sm"><i class="fa fa-home"></i> Home </a-->

        <table class="table table-striped table-padding" id="tbl-gudang" width="100%">
            <thead>
               <tr class="tblheader">
                  <th width="30">KODE</th>
                  <th>Nama Gudang</th>
            	  <th>Alamat</th>
            	  <th width="80">Gd.Utama</th>
                  <th width="30">Act</th>
               </tr>
            </thead>
            <tbody></tbody>
        </table>

            </div>
        </div>
    </div>
</div>

@include('gudang.form')
@endsection

@section('script')
<script type="text/javascript">

var table, save_method;

$(function(){
   table = $('.table').DataTable({
        "processing" : true,
        "dom" : "bti",
        "order": [[3,'DES']],
        "ajax" : {
            "url" : "{{ route('gudang.data') }}",
            "type" : "GET"
        }
    }); 
   
    $('#modal-form form').validator().on('submit', function(e){
        if(!e.isDefaultPrevented()){
            var id = $('#id').val();
            if(save_method == "add") url = "{{ route('gudang.store') }}";
            else url = "gudang/"+id;
         
            $.ajax({
                url : url,
                type : "POST",
                data : $('#modal-form form').serialize(),
                dataType :"JSON",
                success : function(data){
                    if(data.msg=='error'){
                        swal('error', 'Data tidak bisa disimpan ','error'); return false;
                    }
                    
                    $('#modal-form').modal('hide');
                    table.ajax.reload(null, false);
                },
                error : function(){
                    alert("Tidak dapat menyimpan data!");
                }   
            });
            return false;
        }
    });
});

function addForm(){
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#modal-form').modal('show');
    $('#modal-form form')[0].reset();            
    
    $('#kode').removeAttr('readonly');
}

function editForm(id){
    save_method = "edit";
    $('input[name=_method]').val('PATCH');
    $('#modal-form form')[0].reset();
   
    $.ajax({
        url : "gudang/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            $('#modal-form').modal('show');
       
            $('#id').val(data.id);
	        $('#kode').val(data.kode).attr('readonly',true);
            $('#nama').val(data.nama);
            $('#alamat').val(data.alamat);
            $('#utama').val(data.is_utama);

        },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });
}


</script>
@endsection