<!DOCTYPE html>
@extends('layouts.app')

@section('title')
  Search Data
@endsection

@section('breadcrumb')
   @parent
   <li>Search Data</li>
@endsection

@section('content') 

 <html> 

<head>
	
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>

</head>

 
 <body>

  <div class="container box">

    <div class="panel-heading"></div> 

    <div class="form-group"> 
    
	<form id="myForm">	
	   <input type="search" name="search" id="search" class="form-input" autofocus autocomplete="off" placeholder=" input No.RC ...   "/>
	  
	   <input type="button" value=" next search " onclick="myFunction()">
	</form>    
	
	</div>

<!-- script untuk reset -->
<script>
function myFunction() {
  document.getElementById("myForm").reset();
  document.getElementById("search").focus();	//kembali ke focus jika clik reset
}
</script>

    <table class="table table-striped table-bordered">
       <thead>
		<tr>
         <th width="50">MBR.NO</th>
         <th width="200">NAMA MBR</th>
		 <th width="50">NO.HP</th>
		 <th width="80">POINT</th>
        </tr>
       </thead>
       <tbody></tbody>
	   </h1>
    </table>
    
  </div>
 </body>
 
</html>

@endsection

@section('script')
 
<script type="text/javascript">
$(document).ready(function(){

       $("#search").keypress(function(e){
            if(e.which == '13'){
                e.preventDefault();
                fetch_data();
            }else if($(this).val().length > 6){
                fetch_data();
            }
        });
 
// fetch_data();
 
 function fetch_data(query = '')
 {
  $.ajax({
   url:"{{ route('livesearch.action') }}",
   method:'GET',
   data:{query:query},
   dataType:'json',
   success:function(data)
   {
	var newRows;
	{
	 newRows += "<tr><td>" + data.mbr_no   + "</td>"
	 newRows += "<td>	 " + data.mbr_nama + "</td>"
	 newRows += "<td>	 " + data.mbr_nohp + "</td>"
	 newRows += "<td> 	 " + data.mbr_point + "</td></tr>"
	  
	}
    
	$('tbody').html(newRows);
    
	}
  })
 }
 
 $(document).on('keyup', '#search', function(){
  var query = $(this).val();
  fetch_data(query);
 });
 
});
</script>

@endsection