@extends('layouts.app')

@section('title')
	
@endsection

@section('breadcrumb')
   @parent
   <li>mutasi stock</li>
@endsection

@section('content')   

<div class="row">
    <div class="container-fluid">
        <div class="card">
            <div class="card-block"> 
    <h6>Mutasi Stock</h6>

    <table class="table table-striped table-padding" id="tbl-mutasi" width="100%">
        <thead>
            <tr class="tblheader">
                <th>No.Mutasi</th>
        	    <th width="100px">Tanggal</th>
        	    <th>Asal</th>
                <th>Tujuan</th>
                <th>Keterangan</th>
                <th width="35px">Act</th> 	  
        	</tr>
        
        </thead>
        <tbody></tbody>
    
    </table>

			</div>
		</div>
	</div>	
</div>


@include('mutasi.form_detail')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;

$(function(){
   table = $('#tbl-mutasi').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "{{ route('mutasi.history') }}",
       "type" : "GET"
     }
   }); 
})   

function showDetail(id){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#form-detail').modal('show');
   $('#form-detail form')[0].reset();   
   tampilHeader(id);
   tampilDetail(id);
}

function tampilHeader(id){
    
    $('#idmts').val(id);
    
    $.ajax({
        url : "{{ DIR_APP }}mutasi/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            $('#nofaktur').text("NO.Mutasi: "+data.nomutasi);
            $('#ketr').text("dari "+data.asal+" ke "+data.tuju);

	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}


    tbdetail = $('#tbldetail').DataTable({
        "scrollY": '55vh',
        "scrollCollapse": true,
        "bSort": false,
        "destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bti',
    });
    
function tampilDetail(id){

    tbdetail.ajax.url("{{ DIR_APP }}mutasi/"+id+"/historydetail");
	tbdetail.ajax.reload();
}    


function printFaktur(){
    var id = $('#idmts').val();
    window.location="{{ DIR_APP }}mutasi/"+id+"/printfaktur";
}



</script>

@endsection
