<head>
    <style>
        #tbl-pegawai th, tr, td {border-bottom:1px black solid; border-top:1px black solid; }
    </style>
</head>

@extends('layouts.app')

@section('title')
  Data Pegawai
@endsection

@section('breadcrumb')
   @parent
   <li>pegawai</li>
@endsection

@section('content')     

<section id="tbl-data" class="show">

<div class="row">
  <div class="container">
    <div class="card">
      <div class="card-block">     

      <div class="text-left">
        <a onclick="addForm()" class="btn btn-outline-info btn-sm"><i class="fa fa-user" ></i> New Pegawai</a>
      </div>

<table class="table table-striped table-padding table-responsive" id="tbl-pegawai" width="100%">
<thead>
   <tr class="tblheader">
      <th width="1%">NIP</th> 
      <th width="20%">Nama</th>
      <th width="7%">Jabatan</th>
      <th width="2%">JNS</th>
      <th width="30%">Alamat</th>      
	  <th width="10%">No.HP</th>
	  <th width="8%">Tgl.Kerja</th>
      <th width="8%">Act</th>
   </tr>
</thead>
<tbody></tbody>
</table>

      </div>
    </div>
  </div>
</div>
</section>

<!---------------------------- form data ------------------------> 

<setcion id="form-data" class="hide">

<form class="form-horizontal" data-toggle="validator" method="post" id="form-input">
   {{ csrf_field() }} {{ method_field('POST') }}
   
<div class="Container-fluid">      

    <div class="card" style="width:100%; margin:auto;">
        <div class="card-block">
            <h6>Form Pegawai</h6>

    <div style="padding:5px 50px">
      
    <input type="hidden" id="id" name="id">
      
    <div class="row">
        <div class="col-sm-5 col-md-5">      

            <div class="form-group">
                <label>NIP</label>
                <input id="nip" type="text" class="form-control" name="nip" maxlength="3" minlength="3" autofocus required autocomplete="off">
                <small class="text-muted">Nomor Induk Pegawai [3 angka]</small>
            </div>
        
            <div class="form-group">
                <label>Nama Pegawai</label>
                <input id="nama" type="text" class="form-control" name="nama" autofocus required autocomplete="off">
                <small class="text-muted">Nama lengkap Pegawai</small>
            </div>

            <div class="form-group">
                <label>JABATAN</label>
                <select id="jbt" type="text" class="form-control" name="jbt" autofocus required>
                    <option value="">--- Pilih Jabatan --- </option>
                    @foreach($jbt as $dt)
                    <option value="{{ $dt->id }}">{{ $dt->jabatan }}</option>
                    @endforeach
                </select>
            </div>              
            
            <div class="form-group">
                <label>Tgl. Kerja</label>
                <input id="tglkerja" type="date" class="form-control" name="tglkerja" autofocus autocomplete="off" required>
                <small class="text-muted">Tgl Masuk kerja</small>
            </div>
            
            <div class="form-group">
                <label>Alamat</label>
                <input id="alamat" type="text" class="form-control" name="alamat" autofocus autocomplete="off" required>
            </div>
            
            <div class="form-group">
                <label>JENIS</label>
                <select id="sex" type="text" class="form-control" name="sex" autofocus required>
                    <option value="0">W-WANITA </option>
                    <option value="1">P-PRIA</option>
                </select>
            </div>            

        </div>
        
        <div class="col-sm-1"></div>
        
        <div class="col-sm-6 col-md-6">


            <div class="form-group">
                <label>No.HP</label>
                <input id="nohp" type="text" class="form-control" name="nohp" autofocus autocomplete="off">
            </div>             

            <div class="form-group">
                <label>No.Rekening Bank</label>
                <input id="norek" type="text" class="form-control" name="norek" autofocus autocomplete="off">
                <small class="text-muted">No. Rekening untuk Gaji</small>
            </div>  
            <div class="form-group">
                <label>Nama Bank</label>
                <input id="bank" type="text" class="form-control" name="bank" autofocus autocomplete="off">
            </div>            

            <div class="form-group">
                <label>Catatan Detail</label>
                <textarea id="ket" name="ket" class="form-control" rows="5" autofocus placeholder="belum ada catatan ..."></textarea>
                <small class="text-muted">Catatan detail tentang pegawai</small>
            </div>



            <div class="form-group">
        	    <button id="submit-control" type="submit" class="btn btn-outline-success"><i class="fa fa-floppy-o"></i> Save </button>
                <button id="tutup" onclick="tutupForm()" type="button" class="btn btn-outline-warning"><i class="fa fa-times"></i> Cancel</button>
            </div>            
            
        </div>
        
    </div>

    </div>
    
            </div>
        </div>
    </div>
</form>

</section>

@include('pegawai.form_kasbon')
@include('pegawai.add_kasbon')

@endsection


@section('script')
<script type="text/javascript">
var table, save_method;

$(function(){
    table = $('.table').DataTable({
        "processing" : true,
        "lengthMenu": [[8, 15, 50, -1], [8, 15, 50, "All"]],       //pilihan jumlah record show
        "ajax" : {
            "url" : "{{ route('pegawai.data') }}",
            "type" : "GET"
        }
    }); 
})
   
    $('#form-input').validator().on('submit', function(e){
      
        if(!e.isDefaultPrevented()){
            var id = $('#id').val();
            if(save_method == "add") url = "{{ route('pegawai.store') }}";
                else url = "pegawai/"+id;
         
            $.ajax({
                url : url,
                type : "POST",
                data : $('#form-input').serialize(),
                dataType: 'JSON',		   
                success : function(data){
 
                    if(data.msg=="error"){
               	        swal("WARNING", " Gagal menyimpan data !","error");
                        $('#nama').focus().select();
                    }else{
                        tutupForm();
				        swal("SUCCESS", " Data Pegawai berhasil disimpan ! ","success");
                        table.ajax.reload(null, false);
                    }   
 		        },
                error : function(){
		            swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");	
                }   
            });
            return false;
        }
    })



/* versi baru */

function addForm(){
	save_method="add";
    $('input[name=_method]').val('POST');

    //$('#burger').click();
	$('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}


function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   
    $.ajax({
        url : "pegawai/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){

            bukaForm();       
            $('#id').val(data.id);
    	    $('#nama').val(data.nama);
            $('#alamat').val(data.alamat);
            $('#jbt').val(data.jabatan_id);
            $('#sex').val(data.is_gender);
    	    $('#nohp').val(data.nohp);
            $('#nip').val(data.nip);
            $('#tglkerja').val(data.tgl_kerja);
            $('#norek').val(data.noacct);
            $('#bank').val(data.bank);
    
            $('#ket').val(data.deskripsi);
       
        },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });
}


function tutupForm(){
    
	$('#form-data').addClass("hide");
	$('#tbl-data').removeClass("hide");
	$('#tbl-data').addClass("show");	

    document.getElementById("form-input").reset();
}

function bukaForm(){
    
    $('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}

function kasbon(id){
   
   $('input[name=_method]').val('POST');
   $('#modal-kasbon').modal('show');
   $('#modal-kasbon form')[0].reset();            
   
   $('#idpeg').val(id);
   tampilDetail(id);
   
}

    tblkasbon = $('#tblkasbon').DataTable({
        "scrollY": '50vh',
        "scrollCollapse": true,
        "bSort": false,
        "destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bti',
    });
    
function tampilDetail(id){

    tblkasbon.ajax.url("{{ DIR_APP }}kasbon/"+id+"/data");
	tblkasbon.ajax.reload();
}    

function addKasbon(){
    
    var id=$('#idpeg').val();
    
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#modal-addkasbon').modal('show');
    $('#modal-addkasbon form')[0].reset();            
   
    $('#id2').val(id);
    tampilpegawai(id);
   
}  

function tampilpegawai(id){
    $.ajax({
        url : "pegawai/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){

	        $('#nmpeg').val(data.nama);

        },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });    
}


    $('#form-addkasbon').validator().on('submit', function(e){
      
        if(!e.isDefaultPrevented()){
            var id = $('#id').val();
            if(save_method == "add") url = "{{ route('kasbon.store') }}";
                else url = "{{ DIR_APP }}kasbon/"+id;
         
            $.ajax({
                url : url,
                type : "POST",
                data : $('#form-addkasbon').serialize(),
                dataType: 'JSON',		   
                success : function(data){
 
                    if(data.msg=="error"){
               	        swal("WARNING", " Gagal menyimpan data !","error");
                        $('#masa').focus().select();
                    }else{
                        $('#modal-addkasbon').modal('hide');
				        swal("SUCCESS", " Data Kasbon berhasil disimpan ! ","success");
                        $('#tblkasbon').DataTable().ajax.reload(null, false);
                    }   
 		        },
                error : function(){
		            swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");	
                }   
            });
            return false;
        }
    })
    
</script>

@endsection