@extends('layouts.app')
<head>
    <style>
        .tblhdr { height:35px; background-color:#3CB371; color: white; font-size: 14px;}
        
        #tblhutang td,tr { font-size:13px; border:0px gray solid;}
        
    </style>
</head>

@section('title')

@endsection

@section('breadcrumb')
   @parent
   <li>Pelunasan Invoice Pembelian</li>
@endsection


@section('content')   
<div class="row">
	<div class="container-fluid">
		<div class="card">
			<div class="card-block">  

<form method="post" id="form-pelunasan">
{{ csrf_field() }}

<h6>Pelunasan Invoice Pembelian</h6>


<table "table table-striped table-padding table-bordered" id="tblhutang" width="100%">    
<thead>
   <tr class="tblhdr">
   
 	    <th width="7%">Tg.Invoice</th>
 	    <th width="12%">No.Invoice</th>
 	    <th width="25%">Supplier</th>
 	    <th width="8%">J.Tempo</th>
		<th width="12%" class="text-right">Total</th>
		<th width="10%" class="text-right">Potongan</th>
		<th width="12%" class="text-right">Bayar</th>
		<th width="25%">Keterangan</th>

	</tr>
</thead>
<tbody></tbody>

</table>
</form>

        </div>

		</div>
	</div>	
</div>

@include('pembayaran.form_create')

@endsection

@section('script')
<script type="text/javascript">
var table;

showData();

function showData(){

    $(document).ready(function(){
        table = $('#tblhutang').DataTable({
            "processing" : true,
            "bSort": false,
            "destroy": true,
            "dom" : "btip",
            "lengthMenu": [[8, 10, 20, -1], [10, 10, 20, "All"]],
            "order": [0, 'desc'],
            "ajax" : {
                "url" : "{{ DIR_APP }}pembayaran/history",
                "type" : "GET"
            }
        })
   }); 
}


</script>

@endsection
