@extends('layouts.app')
<head>
    <style>
        .tblhdr { height:35px; background-color:#3CB371; color: white; font-size: 14px;}
        
        #tblhutang td,tr { font-size:13px; border:0px gray solid;}
        
    </style>
</head>

@section('title')

@endsection

@section('breadcrumb')
   @parent
   <li>Pelunasan Invoice Pembelian</li>
@endsection


@section('content')   
<div class="row">
	<div class="container-fluid">
		<div class="card">
			<div class="card-block">  

<form method="post" id="form-pelunasan">
{{ csrf_field() }}

<h6>Pelunasan Invoice Pembelian</h6>

<section id="header" class="show">
    
<div class="row">
    <div class="col-sm-5 col-md-5">
        <div class="form-group">
            <label>Supplier/Principle</label>
            
            <select type="text" id="sup" name="sup" autofoucs class="form-control">
                <option value="">--- Pilih Principle/Supplier ---</option>
                @foreach($sup as $list)
                    <option value="{{ $list->id }}">{{ $list->sup_nama }}</option>
                @endforeach
            </select>
        </div>    
    </div>
 
	<div class="col-md-2"> 
        <label></label>
		<button type="button" class="btn btn-primary btn-sm pull-right" onclick="showData()" style=margin-top:30px;><i class="fa fa-table"></i> View </button>
    </div>
</div>
</section>


<table "table table-striped table-padding table-bordered" id="tblhutang" width="100%">    
<thead>
   <tr class="tblhdr">
   
 	    <th width="7%">Tg.Invoice</th>
 	    <th width="25%">No.Invoice</th>
 	    <th>Supplier</th>
 	    <th width="8%">J.Tempo</th>
		<th width="12%" class="text-right">Total</th>
		<th width="5%"></th>

	</tr>
</thead>
<tbody></tbody>

</table>
</form>

        </div>

		</div>
	</div>	
</div>

@include('pembayaran.form_create')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method, mgr;

function showData(){

    var sup= $('#sup').val();

    $(document).ready(function(){
        table = $('#tblhutang').DataTable({
            "processing" : true,
            "bSort": false,
            "destroy": true,
            "dom" : "btip",
            "lengthMenu": [[8, 10, 20, -1], [10, 10, 20, "All"]],
            "order": [0, 'desc'],
            "ajax" : {
                "url" : "{{ DIR_APP }}pembayaran/"+sup+"/tampildata",
                "type" : "GET"
            }
        })
   }); 
}

//submit
	$('#modal-form_create').on("submit", function(e) {
	    
      if(!e.isDefaultPrevented()){
		 
		 $('#submit-control').html(' Simpan Create ... ');
		 $('#submit-control').attr('disabled','disabled');
		  
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('pembayaran.store') }}";
         else url = "{{ DIR_APP }}pembayaran/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form_create form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
				if(data.msg=="error-1"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Nominal Pembayaran invalid !","error");
					return false;
				}
				if(data.msg=="error-2"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Nominal Pembayaran lebih kecil dari Faktur !","error");
					return false;
				    
				}else{
				
				    $('#modal-form_create').modal('hide');
					swal("SUCCESS", " Pelunasan berhasil dicreate ! ","success");
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');					
					table.ajax.reload();
				 }   
 		   },
           error : function(){
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
	 }
   })
   

function pelunasan(id){

    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#modal-form_create').modal('show');
    $('#modal-form_create form')[0].reset();        
    
    tampilHeader(id);
} 	 


function tampilHeader(id){
    $('#id').val(id);

    $.ajax({
        url : "{{ DIR_APP }}pembayaran/"+id+"/tampilbayar",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            
            $('#nofaktur').text("NO.Faktur: "+data.inv_no);
            $('#tlfaktur').val(data.inv_netto);

            $('#submit-control').removeAttr('disabled');

	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}


</script>

@endsection
