@extends('layouts.myform2')

@section('title')
<!--	Pilih Master SKU Pricelist&nbsp;&nbsp;&nbsp;-->
	<tr><td width="80"><b>Supplier :&nbsp;&nbsp;</b></td><td><b>{{ $dtsupl->sup_id }}&nbsp;&nbsp;-&nbsp;&nbsp;{{ $dtsupl->sup_nama }}</b></td></tr>	
	&nbsp;&nbsp;<a onclick="window.history.back()" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
	
@endsection

@section('breadcrumb')
   @parent
   <li>pilih produk pricelist</li>
@endsection

<head>
    <title>Master SKU</title>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
 
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script> 
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>
	<script type="text/javascript" src="/mms/public/adminLTE/dist/css/sweetalert.min.js"></script>

</head>


@section('content')   
<div class="row">
  <div class="col-xs-13">
    <div class="box">
      <div class="box-body">  


<form method="post" id="form-produk">
{{ csrf_field() }}
<table class="table table-striped table-bordered" id="produk">
<thead>
   <tr>
      <th>SKU</th>
      <th>Description</th>
      <th>Category</th>
      <th>Aksi</th>
   </tr>
</thead>
<tbody></tbody>
</table>
</form>

    </div>
	</div>
	</div>
</div>	

@include('pilihproduct.form')

@endsection

@section('script')


<script type="text/javascript">
var save_method;
$(document).ready(function() {
	var table = $('#produk').DataTable ({
        "processing": true,
        "serverSide": true,
        "ajax": "{{ route('product.pilihdata') }}",
        "columns":[
            { "data": "sku_kode","width": "35px"},
            { "data": "sku_name" },
			
			{ 
			"data": "cat_name",
			"width": "100px",
			"sClass": "text",
			"orderable":true,
			"searchable":false
			},
		
			{
                "data": "id_sku",
                "sClass": "text-center",
                "orderable": false,
                "mRender": function (data) {
                           return '<a onclick="addForm('+data+')" class="btn btn-success btn-sm"><i class="fa fa-plus"></i></a>'
                         }
            }
  			
        ]
     });
	 
//});

	 
//submit
	  $(document).on("submit", function(e) {
      if(!e.isDefaultPrevented()){
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('pricelist.store') }}";
         //else url = "/mms/pricelist/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
             if(data.msg=="error"){
               	swal("WARNING", " Gagal menyimpan data, sudah terdaftar !","error");
                $('#nama').focus().select();
             }else{
                $('#modal-form').modal('hide');
				swal("SUCCESS", " Pricelist baru berhasil disimpan ! ","success");
                table.ajax.reload();
             }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");			 
           }   
         });
         return false;
	 }
   });
});


function addForm(id){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form form')[0].reset();
   $.ajax({
     //url : "/mms/product/"+id+"/edit",
	 url : "/mms/pricelist/"+id+"/tambah",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Add Pricelist');
       
		$('#id').val(data.id_sku);
		$('#kode').val(data.sku_kode)
		$('#nama').val(data.sku_name).attr('readonly', true);
	                 
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

function add_Form(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form').modal('show');
   $('#modal-form form')[0].reset();            
   $('.modal-title').text('New List');
}
  
</script>


@endsection