@extends('layouts.myform')

@section('title')
	
	<tr><td width="80"><b>Supplier :&nbsp;&nbsp;</b></td><td><b>{{ $supplier->sup_id }}&nbsp;&nbsp;-&nbsp;&nbsp;{{ $supplier->sup_nama }}</b></td></tr>&nbsp;&nbsp;
	<a onclick href="/mms/pricelist/{{ $supplier->id_supp }}/pilihproduct" class="btn btn-success"><i class="fa fa-plus-circle"> </i> New Pricelist </a> 
	<a onclick="window.history.back()" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
	
	
@endsection

@section('breadcrumb')
   @parent
   <li>pricelist</li>
@endsection

<head>
    <title>Price List</title>

	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script> 
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>
	<script type="text/javascript" src="/mms/public/adminLTE/dist/css/sweetalert.min.js"></script>

</head>


@section('content')   
<div class="row">
  <div class="col-xs-13">
    <div class="box">
      <div class="box-header">

      </div>
      <div class="box-body">  

<form method="post" id="form-pricelist">
{{ csrf_field() }}

<table class="table table-striped table-bordered" id="pricelist">
<thead class="thead-dark">
   <tr class="success">
      <th>SKU</th>
      <th>Description</th>
      <th>BOX</th>
	  <th>PCS</th>
	  <th>HG.GROSS</th>
	  <th>DISC1</th>
	  <th>DISC2</th>
	  <th>DISC3</th>
	  <th>PPN</th>
	  <th>STS</th>
	  <th>List.Exp</th>
      <th width="30">Aksi</th>
   </tr>
</thead>
<tbody></tbody>
</table>
</form>

    </div>
	</div>
	</div>
</div>	

@include('pricelist.form')

@endsection

@section('script')


<script type="text/javascript">
var save_method;
$(document).ready(function() {
	var table = $('#pricelist').DataTable ({
        "processing": true,
        "serverSide": true,
        "ajax": "{{ route('pricelist.tampildata') }}",
        "columns":[
            //{ "data": "sup_kode","width": "20px"},
			{ "data": "list_sku" },
            { "data": "sku_name", "searchable" : false },
			{ "data": "prc_box", "searchable" : false },
			{ "data": "prc_pcs", "searchable" : false },
			{ "data": "prc_hrggross", "searchable" : false },
			{ "data": "prc_disc1", "searchable" : false },
			{ "data": "prc_disc2", "searchable" : false },
			{ "data": "prc_disc3", "searchable" : false },
			{ "data": "prc_ppn", "searchable" : false },
			{ "data": "prc_status", "searchable" : false },
			{ "data": "list_exp", "searchable" : false },
		
			{
                "data": "id_plist",
                "sClass": "text-center",
                "orderable": false,
                "mRender": function (data) {
                           return '<a onclick="editForm('+data+')" class="btn btn-primary btn-sm"><i class="fa fa-pencil"></i></a> '
						   ' <a onclick="showData('+data+')" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i></a>'
                         }
            }
  			
        ]
     });
	 
//submit
	  $(document).on("submit", function(e) {
      if(!e.isDefaultPrevented()){
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('pricelist.store') }}";
         else url = "/mms/pricelist/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
             if(data.msg=="error"){
               	swal("WARNING", " Gagal menyimpan data !","error");
                $('#nama').focus().select();
             }else{
                $('#modal-form').modal('hide');
				swal("SUCCESS", " Master SKU baru berhasil disimpan ! ","success");
                table.ajax.reload();
             }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");			 
           }   
         });
         return false;
	 }
   });
});


function editForm(id){
   save_method = "edit";
 
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "/mms/pricelist/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Pricelist');
       
       $('#id').val(data.id_plist);
	   $('#supp').val(data.sup_kode.concat(' - ',data.sup_nama));
  	   $('#nama').val(data.list_sku.concat(' - ',data.sku_name));
	   $('#box').val(data.prc_box);
       $('#pcs').val(data.prc_pcs);
       $('#gross').val(data.prc_hrggross);
	   $('#disc1').val(data.prc_disc1);
	   $('#disc2').val(data.prc_disc2);
	   $('#disc3').val(data.prc_disc3);
	   $('#ppn').val(data.prc_ppn);
	   $('#status').val(data.prc_status);
	                 
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

function showData(id){
   save_method = "edit";

   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "/mms/pricelist/"+id+"/lihat",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Data Detail');
       
       $('#id').val(data.id_plist);
	   $('#supp').val(data.sup_kode.concat(' - ',data.sup_nama));
  	   $('#nama').val(data.list_sku.concat(' - ',data.sku_name));
	   $('#box').val(data.prc_box).attr('readonly', true);
       $('#pcs').val(data.prc_pcs).attr('readonly', true);
       $('#gross').val(data.prc_hrggross).attr('readonly', true);
	   $('#disc1').val(data.prc_disc1).attr('readonly', true);
	   $('#disc2').val(data.prc_disc2).attr('readonly', true);
	   $('#disc3').val(data.prc_disc3).attr('readonly', true);
	   $('#ppn').val(data.prc_ppn).attr('readonly', true);
	   $('#status').val(data.prc_status).attr('readonly', true);
	   $('#expd').val(data.list_exp).attr('readonly', true);
	                 
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });   
   
}


</script>

@endsection
