@extends('layouts.app')

<head>
  
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
  
</head>

@section('breadcrumb')
   @parent
   <li>report penjualan</li>
@endsection


@section('content')

<div class="container-fluid">
    <div class="card">
        <div class="card-block">

<!--form method="post" id="form-report"-->


<form class="form-horizontal" data-toggle="validator" method="post" id="form-report">
{{ csrf_field() }} {{ method_field('POST') }}

<h5><center>Laporan Penjualan Pajak</center></h5>
<br>
    
    <div class="row">   <!--/div> style="padding:5px 20px;"-->
        
        <div class="col-md-6 col-sm-6">
            <div class="col-md-12">
                <div class="form-group">
             		<div class="col-md-6">
            		    <label>Tgl. Awal</label>
            			<input id="awal" type="date" class="form-control" name="awal" autofocus required>
            		</div>
            		<div class="col-md-6">
            		    <label>Tgl. Akhir</label>
            			<input id="akhir" type="date" class="form-control" name="akhir" autofocus required>
            		</div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6 col-sm-6">
            <table "table" id="tbl-supp" width="100%" height:"auto">
                <thead>
                    <tr class="tblheader" height="30px">
                        <th width="90%">Principel</th>
                        <th width="10%"></th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>

    <div class="col-md-12 text-center">	
    	<br>
    	<!--button type="submit" class="btn btn-success" onclick="exportExcell()"><i class="fa fa-file-excel-o"></i> Export to Excell </button-->
    	<a class="btn btn-success" onclick="exportExcell()"><i class="fa fa-file-excel-o"></i> Export to Excell </a>
    	<!--button type="submit" class="btn btn-success btn-sm" onclick="exportCSV()"><i class="fa fa-file-excel-o"></i> Export to CSV </button-->
    	<!--button type="submit" class="btn btn-primary btn-sm" onclick="viewReport()"><i class="fa fa-table"></i> View Report </button-->
    
    	<a href="{{ route('home') }}" class="btn btn-warning"><i class="fa fa-home"></i> Home </a>
        <br>
    </div>
        
</form>

        </div>
    </div>
</div>

@endsection

@section('script')

<script type="text/javascript">

var table, tgl1, tgl2, cus, tbl_report;

$(document).ready(function(){

})

showSupp();

function showSupp(){
    $(function(){
    	$.fn.dataTable.ext.errMode = 'throw';
    	table = $('#tbl-supp').DataTable({
    		 "paging": true,
    		 "iDisplayLength": 30,
         	 "processing" : true,
    		 "searching" : false,
    		 "destroy": true,
    		 "sort": false,
    		 "dom" : "bt",
    		 "ajax" : {
    			"url" : "{{ DIR_APP }}report/pilihsupp",
    			"type" : "GET"
    		}
    	}); 
    });
}


function viewReport(){
    $('#form-report').attr('action', "{{ DIR_APP }}report/viewreportpajak").submit();       //--> open new windows
    //location.reload();
}


function exportExcell(){
    
    if($('input:checked').length < 1){
        swal("WARNING"," Principel harus dipilih !! ","info");
        return false;
    }else{    
        $('#form-report').attr('action', "{{ DIR_APP }}report/exportpajak").submit();       
        //location.reload();
    }
}

function exportCSV(){
    $('#form-report').attr('action', "{{ DIR_APP }}report/pajakcsv").submit();       //--> open new windows
    //location.reload();
}



</script>

@endsection