@extends('layouts.print')

<head>
    <style>
        tr, td {font-size:1.75rem; }
    
        @page {
            size: A4;
            margin: 10mm 2mm 20mm 2mm;    
            
            @bottom-center {
                content: counter(page);
            }
        }
        
        @page :left: header {
            content: "Page " decimal(pageno), , first(chapter);
            font-variant: small-caps
        }
        @page :right :header {
            content: last(section), , "Page " decimal(pageno);
            font-variant: small-caps
        }    
    
        table.report-container {
            page-break-after:always;
        }
        thead.report-header {
            display:table-header-group;
        }
        tfoot.report-footer {
            display:table-footer-group;
        }    
        
        #tblisi th { border-bottom:1px black solid; }
    
    </style>    
</head>

<body>
        
    <script type="text/javascript">
         //window.onload = addPageNumbers;

        function addPageNumbers() {
            var totalPages = Math.ceil(document.body.scrollHeight / 600);  //842px A4 pageheight for 72dpi, 1123px A4 pageheight for 96dpi, 
            for (var i = 1; i <= totalPages; i++) {
              var pageNumberDiv = document.createElement("div");
              var pageNumber = document.createTextNode("Page " + i + " of " + totalPages);
              pageNumberDiv.style.position = "absolute";
              pageNumberDiv.style.marginTop = "calc((" + i + " * (297mm )) - 400mm - 0.5px)"; //297mm A4 pageheight; 0,5px unknown needed necessary correction value; additional wanted 40px margin from bottom(own element height included)
              pageNumberDiv.style.marginTop = 1000px;
              pageNumberDiv.style.marginRight = 50px;
              pageNumberDiv.style.height = "16px";
              pageNumberDiv.appendChild(pageNumber);
              document.body.insertBefore(pageNumberDiv, document.getElementById("content"));
              pageNumberDiv.style.left = "calc(100% - (" + pageNumberDiv.offsetWidth + "px + 20px))";
            }
          }
    </script>


@section('title')
    Report Sale &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

  	<!--a onclick="window.location='{{ route('home') }}'" class="btn btn-primary"><i class="fa fa-home"></i> Home </a-->
	<a onclick="window.history.go(-1)" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
	<a onclick="myFunction()" class="btn btn-success"><i class="fa fa-print"></i>Print Dokumen</a>
    <!--a onclick="printmatrix()" class="btn btn-success"><i class="fa fa-print"></i>Print Faktur</a-->

    <script>
        function myFunction() {
          window.print();
        }
    </script>
@endsection

@section('breadcrumb')
   @parent
     <li>report sale</li>
@endsection

@section('content')

<h4>REPORT SALE</h4>

<h4 style="margin-top:-25px; margin-left:400px;">Periode : {{ tanggal_indonesia($tgl1, false)." s/d ". tanggal_indonesia($tgl2, false) }}</h4>

<table class="report-container" cellspacing="5" cellpadding="5"  style="width:100%;" id="tblisi">
    
    <thead class="report-header">  
    
        <tr border="1">
        	<th width="105">Tanggal</th>
        	<th width="105">No.Faktur</th>
        	<th width="200">Pelanggan</th>
        	<th width="200">Principel</th>
        	<th width="250" class="text-left">Nama Produk</th>
        	<th width="90" class="text-right">Harga</th>
        	<th width="80" class="text-right">Jumlah</th>
        	<th width="80" class="text-right">Potongan</th>
        	<th width="80" class="text-right">DPP</th>
        	<th width="80" class="text-right">PPN</th>
        	<th width="90" class="text-right">Total</th>
        </tr>
    </thead>
    
    @foreach ($dt as $list)
    	<tr>
    	   	<td>{{ $list->sale_tgl }}</td>
    	   	<td>{{ $list->sale_no }}</td>
    	   	<td>{{ $list->cus_name }}</td>
    	   	<td>{{ $list->sup_nama }}</td>
        	<td>{{ $list->nama_brg }}</td>
        	<td align="right">{{ format_uang($list->harga) }}</td>
        	<td align="right">{{ format_uang($list->qty) }}</td>
        	<td align="right">{{ format_uang($list->potongan) }}</td>
        	<td align="right"></td>
        	<td></td>
        	<td align="right">{{ format_uang(($list->qty* $list->harga) - $list->potongan) }}</td>
        </tr>
    @endforeach
    

<!--tfoot class="report-footer">
    <tr><td></td><td><h6>#report sale</h6></td></tr>
</tfoot-->

    
</table>



<!--hr> <!--style="width:96%; margin-top:5px; margin-bottom:5px; background-color: black; height: 1px; border:1;"-->


@endsection

<script type="text/javascript">
    
    function printmatrix(){
        
        var idinv = $('#idinv').val();
        
        var ua = navigator.userAgent.toLowerCase();
        var isAndroid = ua.indexOf("android") > -1; //&& ua.indexOf("mobile");
                	
        if(isAndroid) {
            var tpdevice='android';
        }else{
            var tpdevice='pclaptop';
        }
            
        $.ajax({
            url : "{{ DIR_APP }}invoice/"+idinv+"/printfaktur_matrix",
            type : "GET",
            dataType : "JSON",
            success : function(data){
                if(tpdevice=='android'){
                    window.location.href=data.data;
                }else{
                	var socket = new WebSocket("ws://127.0.0.1:40213/");        /* harus dijalankan dulu dari rawbt.bat */
                    socket.bufferType = "arraybuffer";
                    socket.onerror = function(error) {
                	    alert("Error");
                    };			
                	socket.onopen = function() {
                		socket.send(data.data);
                		socket.close(1000, "Work complete");
                	};                    
                }
                    
                //ocation.reload();
        
            },
            error : function(){
                alert("error print...");
            }
        });
    }

</script>
