<?php
    use App\Bank;
?>


@extends('layouts.print')

<head>
    <style>
        tr, td {font-size:1.50rem; }
    
        @page {
            size: A4;
            margin: 10mm 10mm 20mm 10mm;    

            @bottom-center {
                content: counter(page);
            }
        }
        
        @page :left: header {
            content: "Page " decimal(pageno), , first(chapter);
            font-variant: small-caps
        }
        @page :right :header {
            content: last(section), , "Page " decimal(pageno);
            font-variant: small-caps
        }    
    
        table.report-container {
            page-break-after:always;
        }
        thead.report-header {
            display:table-header-group;
        }
        tfoot.report-footer {
            display:table-footer-group;
        }    
    
        #tblisi th,td { border-bottom:1px black solid; }
        
    </style>    
</head>

<body>
        
    <script type="text/javascript">
         //window.onload = addPageNumbers;

        function addPageNumbers() {
            var totalPages = Math.ceil(document.body.scrollHeight / 600);  //842px A4 pageheight for 72dpi, 1123px A4 pageheight for 96dpi, 
            for (var i = 1; i <= totalPages; i++) {
              var pageNumberDiv = document.createElement("div");
              var pageNumber = document.createTextNode("Page " + i + " of " + totalPages);
              pageNumberDiv.style.position = "absolute";
              pageNumberDiv.style.marginTop = "calc((" + i + " * (297mm )) - 400mm - 0.5px)"; //297mm A4 pageheight; 0,5px unknown needed necessary correction value; additional wanted 40px margin from bottom(own element height included)
              pageNumberDiv.style.marginTop = 1000px;
              pageNumberDiv.style.marginRight = 50px;
              pageNumberDiv.style.height = "16px";
              pageNumberDiv.appendChild(pageNumber);
              document.body.insertBefore(pageNumberDiv, document.getElementById("content"));
              pageNumberDiv.style.left = "calc(100% - (" + pageNumberDiv.offsetWidth + "px + 20px))";
            }
          }
    </script>


@section('title')
    Report Piutang &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

  	<!--a onclick="window.location='{{ route('home') }}'" class="btn btn-primary"><i class="fa fa-home"></i> Home </a-->
	<a onclick="window.history.go(-1)" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
	<a onclick="myFunction()" class="btn btn-success"><i class="fa fa-print"></i>Print Report</a>
    <!--a onclick="printmatrix()" class="btn btn-success"><i class="fa fa-print"></i>Print Faktur</a-->

    <script>
        function myFunction() {
          window.print();
        }
    </script>
@endsection

@section('breadcrumb')
   @parent
     <li>report piutang</li>
@endsection

@section('content')

<h4>REPORT PIUTANG</h4>

<h4 style="margin-top:0px;"><b>PROJECT : {{ $project->project_name }}</b></h4>
<h4 style="margin-top:-5px;" class="text-right">Type : {{ $byr }}</h4>


<table class="report-container" cellspacing="3" cellpadding="3"  style="width:100%;" id="tblisi">
    
    <thead class="report-header">  
    
        <tr border="1">
        	<th width="35">NO</th>
        	<th width="5">&nbsp;</th>
        	<th width="250" class="text-left">Nama Customer</th>
        	<th width="100" class="text-left">BLOCK</th>
        	<th width="120" class="text-right">HARGA RUMAH</th>
        	<th width="8">&nbsp;</th>
        	<th width="80" class="text-left">CARA BAYAR</th>
        	<th width="80" class="text-left">BANK</th>
        	<th width="90" class="text-right">ANGSURAN</th>
        	<th width="90" class="text-right">SISA ANGSURAN</th>
        </tr>
    </thead>
    
    @foreach ($dt as $list)
    	<tr>
    	    <td width="30" align="right" style="font-size:13px">{{ $no++ }}</td>
    	    <td>&nbsp;</td>
        	<td style="font-size:13px">{{ $list->cus_name }}</td>
        	<td style="font-size:13px">{{ $list->cluster.'/'.$list->block.'/'.$list->nomor }}</td>
        	<td align="right" style="font-size:13px">{{ format_uang($list->harga_rumah) }}</td>
        	<td>&nbsp;</td>
        	<td style="font-size:13px">{{ $list->tipe }}</td>
        	
        	@if(is_null($list->bank_id))
        	    <td></td>
        	@else
        	    <td style="font-size:13px">{{ Bank::cek_bank($list->bank_id)->nama }}</td>
        	@endif
        	
        	<td align="right" style="font-size:13px">{{ format_uang($list->total_cicilan) }}</td>
        	<td align="right" style="font-size:13px">{{ format_uang($list->harga_rumah-$list->total_cicilan) }}</td>
        </tr>
    @endforeach
    
    	<tr>
    	   	<td></td>
    	   	<td></td>
        	<td><b>GRAND TOTAL</b></td>
        	<td></td>
        	<td></td>
        	<td></td>
        	<td></td>
        	<td></td>
        	<td></td>
        	<td align="right"><b>{{ format_uang($ttl-$ccl) }}</b></td>
        </tr>    
    
<!--tfoot class="report-footer">
    <tr><td></td><td><h6>#report sale</h6></td></tr>
</tfoot-->

    
</table>



<!--hr> <!--style="width:96%; margin-top:5px; margin-bottom:5px; background-color: black; height: 1px; border:1;"-->


@endsection

