@extends('layouts.app')

@section('title')
  Pengaturan
@endsection

@section('breadcrumb')
   @parent
   <li>pengaturan</li>
@endsection

@section('content')     
<div class="row">
    <div class="container-fluid">
        <div class="card">
            <div class="card-block" >  

    <form class="form form-horizontal" data-toggle="validator" method="post">
    {{ csrf_field() }} {{ method_field('PATCH') }}
    
    <div style="margin-top:20px;margin-left:50px;margin-right:50px;">
        
        <div class="form-group">
            <label>Nama Perusahaan</label>
            <input id="nama" type="text" class="form-control" name="nama" required readonly="true">
            <span class="help-block with-errors"></span>
        </div>
        
        
        <div class="form-group">
            <label>Alamat</label>
            <input id="alamat" type="text" class="form-control" name="alamat" required readonly="true">
            <span class="help-block with-errors"></span>
        </div>

        <div class="form-group">
            <label>Telepon</label>
            <input id="telepon" type="text" class="form-control" name="telepon" required readonly="true">
            <span class="help-block with-errors"></span>
        </div>
        
        
        <div class="form-group">
            <label>Masa Aktif</label>
            <input id="masa" type="date" class="form-control" name="masa">
        </div>
        
    </div>
    
    <div class="box-footer">
        <a onclick="window.location='{{ route('home') }}'" class="btn btn-warning btn-sm"><i class="fa fa-home"></i> Home </a>
        <button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-floppy-o"></i> Simpan Perubahan</button>
    </div>
    <br>
    
    </div>
    </div>  
</form>

  </div>
</div>
@endsection

@section('script')
<script type="text/javascript">

$(function(){

    showData();

    $('.form').validator().on('submit', function(e){
        if(!e.isDefaultPrevented()){ 

            $.ajax({
                url : "{{ DIR_APP }}setting/renew",
                type : "GET",
                data : $(".form").serialize(),
                dataType :"JSON",
                success : function(data){
                    if(data.msg=="success"){
                        
                        swal('info', 'Perpanjang masa aktif berhasil', 'success');
                    }
                },
                error : function(){
                    alert("Tidak dapat menyimpan data!");
                }   
            });
            return false;
        }
    });

});

function showData(){
    $.ajax({
        url : "{{ DIR_APP}}setting/1/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            $('#nama').val(data.nama_company);
            $('#alamat').val(data.alamat);
            $('#telepon').val(data.telepon);
            $('#masa').val(data.valid_until);
        },
        error : function(){
            alert("Tidak dapat menyimpan data!");
        }   
    });
}

</script>
@endsection