<?php
    namespace App\Http\Controllers;
?>


@extends('layouts.print')

<head>
    <style>
        tr, td {font-size:1.75rem; }
        
        @page {
            size: A4;
            margin: 10mm 2mm 20mm 2mm;    
            
            @bottom-center {
                content: counter(page);
            }
        }
        
        @page :left: header {
            content: "Page " decimal(pageno), , first(chapter);
            font-variant: small-caps
        }
        @page :right :header {
            content: last(section), , "Page " decimal(pageno);
            font-variant: small-caps
        }    
    
        table.report-container {
            page-break-after:always;
        }
        thead.report-header {
            display:table-header-group;
        }
        tfoot.report-footer {
            display:table-footer-group;
        }    
        
        #tblisi th, tr, td { border-bottom:1px black solid; }
    
    </style>    
</head>

<body>
        
    <script type="text/javascript">
         //window.onload = addPageNumbers;

        function addPageNumbers() {
            var totalPages = Math.ceil(document.body.scrollHeight / 600);  //842px A4 pageheight for 72dpi, 1123px A4 pageheight for 96dpi, 
            for (var i = 1; i <= totalPages; i++) {
              var pageNumberDiv = document.createElement("div");
              var pageNumber = document.createTextNode("Page " + i + " of " + totalPages);
              pageNumberDiv.style.position = "absolute";
              pageNumberDiv.style.marginTop = "calc((" + i + " * (297mm )) - 400mm - 0.5px)"; //297mm A4 pageheight; 0,5px unknown needed necessary correction value; additional wanted 40px margin from bottom(own element height included)
              pageNumberDiv.style.marginTop = 1000px;
              pageNumberDiv.style.marginRight = 50px;
              pageNumberDiv.style.height = "16px";
              pageNumberDiv.appendChild(pageNumber);
              document.body.insertBefore(pageNumberDiv, document.getElementById("content"));
              pageNumberDiv.style.left = "calc(100% - (" + pageNumberDiv.offsetWidth + "px + 20px))";
            }
          }
    </script>


@section('title')
    Report Stock &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

  	<!--a onclick="window.location='{{ route('home') }}'" class="btn btn-primary"><i class="fa fa-home"></i> Home </a-->
	<a onclick="window.history.go(-1)" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
	<a onclick="myFunction()" class="btn btn-success"><i class="fa fa-print"></i>Print Dokumen</a>
    <!--a onclick="printmatrix()" class="btn btn-success"><i class="fa fa-print"></i>Print Faktur</a-->

    <script>
        function myFunction() {
          window.print();
        }
    </script>
@endsection

@section('breadcrumb')
   @parent
     <li>report sstock</li>
@endsection

@section('content')

<h4>REPORT STOCK</h4>
<h5>Gudang {{ $gudang->kode."-".$gudang->nama }}</h5>
<h5>Tgl. Cetak : {{ date('Y-m-d H:i:s', time()) }}</h5>


<table class="report-container"  cellspacing="5" cellpadding="2"  style="width:98%;" id="tblisi">
    
    <thead class="report-header">  
    
        <tr border="1">
        	<th width="275" class="text-left">Nama Barang</th>
        	<th width="70" class="text-right">AWAL</th>
        	<th width="120" class="text-center">Tgl</th>
        	<th width="70" class="text-right">MASUK</th>
        	<th width="70" class="text-right">OUT</th>
        	<th width="70" class="text-right">MUTASI</th>
        	<th width="70" class="text-right">SISA</th>
        	<th width="5"></th>
        	<th width="150">Keterangan</th>
        </tr>
    </thead>
    
    @foreach ($stk as $list)
    	<tr>
        	<td>{{ $list->get_product->nama_brg }}</td>
        	<td align="right">{{ number_format($list->stock_awal) }}</td>
        	<td align="center">{{ tanggal_indonesia($list->tgl_awal, false) }}</td>
        	<td align="right">{{ $list->stock_in }}</td>
        	<td align="right">{{ $list->stock_out }}</td>
        	<td align="right">{{ $list->stock_mts_in - $list->stock_mts_out }}</td>
        	<td align="right">{{ $list->stock_akhir }}</td>
        	<td></td>
        	<td></td>
        </tr>
    @endforeach
    
</table>


@endsection

<script type="text/javascript">
    
    function printmatrix(){
        
        var idinv = $('#idinv').val();
        
        var ua = navigator.userAgent.toLowerCase();
        var isAndroid = ua.indexOf("android") > -1; //&& ua.indexOf("mobile");
                	
        if(isAndroid) {
            var tpdevice='android';
        }else{
            var tpdevice='pclaptop';
        }
            
        $.ajax({
            url : "{{ DIR_APP }}invoice/"+idinv+"/printfaktur_matrix",
            type : "GET",
            dataType : "JSON",
            success : function(data){
                if(tpdevice=='android'){
                    window.location.href=data.data;
                }else{
                	var socket = new WebSocket("ws://127.0.0.1:40213/");        /* harus dijalankan dulu dari rawbt.bat */
                    socket.bufferType = "arraybuffer";
                    socket.onerror = function(error) {
                	    alert("Error");
                    };			
                	socket.onopen = function() {
                		socket.send(data.data);
                		socket.close(1000, "Work complete");
                	};                    
                }
                    
                //ocation.reload();
        
            },
            error : function(){
                alert("error print...");
            }
        });
    }

</script>
