@extends('layouts.app')

@section('title')

@endsection

@section('breadcrumb')
   @parent
   <li>stock opname</li>
@endsection

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Stock Opname </title>

	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script> 
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>

	<script type="text/javascript" src="public/adminLTE/dist/css/sweetalert.min.js"></script>

	<style>
		.tblheader {
			background: #2F4F4F;
			color: white;
			font-size: 15px;
			alignment: center;
		}
	</style>	
</head>


@section('content')   
<div class="row">
	<div class="container-fluid">
		<div class="card">
			<div class="card-block">  

<a onclick="addForm()" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"> </i> New Opname </a> 

<table class="table table-striped table-padding" id="opname" width="100%">
<thead>
   <tr class="tblheader">
   
	  <th width="100">Tgl.Opname</th>
      <th width="250">Gudang</th>
      <th>Deskripsi</th>
	  <th width="60">Posted</th>
      <th width="50">Act</th> 	  
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>

@include('stockopname.opname_create')
@include('stockopname.form_detail')
@include('stockopname.add_detail')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
$(function(){
   table = $('#opname').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "{{ route('stockopname.header') }}",
       "type" : "GET"
     }
   }); 
   
//submit
	  $(document).on("submit", function(e) {
      if(!e.isDefaultPrevented()){
		 
		 $('#submit-control').html(' Simpan Opname ... ');
		 $('#submit-control').attr('disabled','disabled');
		  
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('stockopname.store') }}";
         else url = "stockopname/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form_create form').serialize(),
           dataType: 'JSON',		   
           success : function(data){

				 if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#gdg').focus().select();
				 }else{
					$('#modal-form_create').modal('hide');
					//swal("SUCCESS", " Opname baru berhasil dicreate ! ","success");
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');					
					table.ajax.reload(null, false);
				 }   
		   },

           error : function(){

			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
	 }
   });
});

function addForm(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form_create').modal('show');
   $('#modal-form_create form')[0].reset();            
   $('.modal-title').text('New Opname');
}
   
function addData(id){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#form-detail').modal('show');
   $('#form-detail form')[0].reset();   
   tampilHeader(id);
   tampilDetail(id);
}

function tampilHeader(id){
    $('#idopn').val(id);
    $('#idopn2').val(id);    
    $.ajax({
        url : "{{ DIR_APP }}stockopname/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            
            $('#gudang').text(data.get_gudang.nama);
            $('#tglopn').text(data.opn_tgl);
            $('#keterangan').text(data.deskripsi);

	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}


    tbdetail = $('#tbldetail').DataTable({
        "scrollY": '55vh',
        "scrollCollapse": true,
        "bSort": false,
        "destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bti',
    });
    
function tampilDetail(id){

    tbdetail.ajax.url("{{ DIR_APP }}stockopname/"+id+"/datadetail");
	tbdetail.ajax.reload();
}    


function addItem(){
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#add_detail').modal('show');
    $('#add_detail form')[0].reset();   
    $('#prd2').removeAttr('disabled');
}

 	tblkemasan = $('.tabel-kemasan').DataTable({
        "bSort": false,
        "destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bt',
    });



//submit add detail
$('#form-add_detail').on("submit", function(e) {

    if(!e.isDefaultPrevented()){
		 
		$('#submit-add').html(' Simpan data ... ');
		$('#submit-add').attr('disabled','disabled');
		  
        var id = $('#iddetail').val();
        if(save_method == "add") { url = "{{ DIR_APP }}stockopname/adddetail"; tipe="POST"; }
        else { url = "{{ DIR_APP }}stockopname/"+id+"/simpanedit" ; tipe="GET"; }

        $.ajax({
            url : url,
            type : tipe,
            data : $('#form-add_detail').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="error"){
					$('#submit-detail').html('Save');
					$('#submit-detail').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#prd').focus().select();
					return false;
				}else{
				    //swal("success", 'success', "success");
					$('#add_detail').modal('hide');
					$('#submit-detail').html('Save');
					$('#submit-detail').removeAttr('disabled');		
		
					$("#tbldetail").DataTable().ajax.reload(null, false);
				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			    $('#submit-detail').html('Save');
			    $('#submit-detail').removeAttr('disabled');			 
            }   
        });
        return false;
	}
});
   
function editDetail(id){
    save_method = "edit";

    $('input[name=_method]').val('PATCH');
    $('#add_detail').modal('show');
    $('#add_detail form')[0].reset();       
    
    $.ajax({
        url : "{{ DIR_APP }}stockopname/"+id+"/editdetail",
        type : "GET",
        dataType : "JSON",
        success : function(data){

            $('#iddetail').val(data.id);
	   
            $('#prd2').val(data.product_id).attr('disabled','disabled');
            $('#kms').val(data.sub_id);
	        $('#harga').val(data.harga_hpp);
	        $('#qty').val(data.opn_qty);
	        $('#kemasan').val(data.satuan.concat(' / ', data.isi));
	 
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}

function posting(){

    swal({
        title: "Anda Yakin ingin memposting Stock Opname ?",
        text: "Data tidak bisa diedit lagi jika sudah diposting !",
        icon: "info",
        buttons: [
            'Batal',
            'Posting'
            ],
        dangerMode: true,
        }).then(function(isConfirm) {
        if (isConfirm) {
            swal({
                title: 'Confirm!',
                text: 'Klik OK untuk melanjutkan Posting !',
                icon: 'info'
            }).then(function() {
                postingOPN();
            });
        }else {
            swal("Batal", "data masih bisa diedit :)", "error");
        }
    })
}    

function postingOPN(){
    
    $.ajax({
        url : "{{ DIR_APP }}stockopname/posting",
        type : "POST",
        data : $('#form-detailfaktur').serialize(),
        dataType: 'JSON',		   
        success : function(data){
		    if(data.msg=="error"){
				swal("WARNING", " Gagal posting data !","error");
				
			}else{
                swal("Success", "Faktur berhasil diposting !", "success");
                location.reload();
			}   
	    },
        error : function(){
		    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
        }   
    });
    return false;
}



function printFaktur(){
    var id = $('#idopn').val();
    window.location="{{ DIR_APP }}stockopname/"+id+"/printfaktur";
}


</script>

@endsection
