<!-- page menampilkan form detail input invoice -->

@extends('layouts.myform')

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  
	
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
   
  	<script type="text/javascript" src="/sbo/public/adminLTE/dist/css/sweetalert.min.js"></script>
  	
	<style>
		.tblheader {
			background: #2F4F4F;
			color: white;
			font-size: 14px;
			alignment: center;
		}
		
	</style>	

</head>


@section('title')
 <table>

    <tr><td width="80"><b>Cabang</b></td><td width="300"><b>{{ $cabang->cbg_name }}</b></td>
	<td width="100"><b>Tgl. Opname</b></td><td><b>{{ tanggal_indonesia($m_opn->opn_tgl, false) }}</b></td></tr>

</table>
 
@endsection

@section('breadcrumb')
   @parent
   <li>stock opname</li>
   <li>input detail</li>
@endsection

@section('content')     

<div class="row">
  <div class="col-xs-12">
    <div class="box">
   
<div class="box-body">

<form class="form form-horizontal form-produk" method="post" id="form-produk">
{{ csrf_field() }}
  
  <input type="hidden" name="idopn" id="idopn" value="{{ $idopn }}">
  <input type="hidden" name="idcbg" id="idcbg" value="{{ $cabang->id_cbg }}">
  
<!--	    <a onclick="printForm()" class="btn btn-info pull-right"><i class="fa fa-print"> </i> Print Stock Opname </a> -->
		<a href="/sbo/stockopnamedetail/{{ $idopn }}/printForm" class="btn btn-info pull-right"><i class="fa fa-print"> </i> Print Stock Opname </a> 
	    <button id="submit-control" type="submit" class="btn btn-success pull-right simpan"><i class="fa fa-floppy-o"> </i> Posting Stock Opname  </button>
		<button type="button" class="btn btn-warning pull-right" onclick="window.history.back()"><i class="fa fa-times-circle"></i> Close </button> 

  <div class="form-group">
      <label for="kode" class="col-md-1 control-label" align="left">List Barang</label>
      <div class="col-md-3">
        <div class="input-group">
          <input id="kode" type="text" class="form-control" name="kode" autofocus required readonly="true">
          <span class="input-group-btn">
            <button onclick="showProduct()" type="button" class="btn btn-info"> + </button>
          </span>
        </div>
      </div>
  </div>

 </form>


<form class="form-detail">
{{ csrf_field() }} {{ method_field('PATCH') }}

<div class="row">
    
<table class="table table-striped table-padding table-bordered tabel-opndetail" id="opndetail" style="background: #DCDCDC;" width="100%">
<thead>
   <tr class="tblheader">       
      <th width="50">No</th>
      <th>Deskripsi</th>
	  <th>No.Seri</th>
      <th>Hg.Retail</th>
	  <th>QTY</th>
	  <th>Jumlah</th>
      <th width="50">Opsi</th>
   </tr>
</thead>


<tbody></tbody>
</table>

</div>

<div class="col-md-8" align="right">
	<label>Total QTY &nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</label><br>
	<label>Total Rp &nbsp;&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;</label><br>
</div>
<div class="col-md-3">
	<div id="total-qty"	style="background: DarkSlateGray; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
	<div id="total-rp" style="background: DarkCyan; color: #fff; font-size: 20px; text-align: right; height: 26px"></div>
</div>

</form>

<div class="box-footer">

	<div class="col-md-3">
		<form class="form form-horizontal form-rekapopn" method="GET" action="/sbo/stockopname/{{ $idopn }}/update">
			{{ csrf_field() }}
			<input type="hidden" name="idopn" value="{{ $idopn }}">

		</form>
	</div>          

</div>
                </div>
            </div>
        </div>
    </div>
</div>


@include('stockopname_detail.produk')
@include('stockopname_detail.form')

@endsection

@section('script')

<script type="text/javascript">
var table, table1, save_method;
var id_opn=$('#idopn').val();

$(function(){
  $('.tabel-produk').DataTable();
  table = $('.tabel-opndetail').DataTable({
      
     "scrollY": '60vh',
     "scrollCollapse": true,
     "paging": false,
     "processing" : true,
	 "dom" : 'bti',
     "ajax" : {
     "url" : "{{ route('stockopnamedetail.data') }}",
     "type" : "GET"
	}


 }).on('draw.dt', function(){
    loadSummary(id_opn);
 });


  $('.form-produk').on('submit', function(e){
      return false;
   });

   $('#kode').change(function(){
      addItem();
   });

/*simpan detail dari form_input */
//$('#modal-form_input form').validator().on('submit', function(e){
   //   if(!e.isDefaultPrevented()){
		 
   //      var id  = $('#id').val();
		 //url = "/sbo/invoicedetail/"+id+"/update";
	//	 url : "{{ route('invoicedetail.store') }}",
    //     $.ajax({
//           url : url,
//           type : "POST",
//           data : $('#modal-form_input form').serialize(),
//           success : function(data){
//             $('#modal-form_input').modal('hide');
//             table.ajax.reload();
//           },
//           error : function(){
//			 return false;
//          }   
//        });
        //return false;
//    }

//		addItem();
});


/* simpan edit detail */
$('#modal-form form').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){
		 
         var id  = $('#id').val();
		 url = "/sbo/stockopnamedetail/"+id+"/update";
         $.ajax({
           url : url,
           type : "GET",
           data : $('#modal-form form').serialize(),
           success : function(data){
             $('#modal-form').modal('hide');
             table.ajax.reload();
           },
           error : function(){
			 return false;
          }   
        });
        return false;
    }
    
}); 

///////////////////////////////////////

/* simpan data ke ms_opname dan posting->stock , cetak  ---> purchase.update */

$('.simpan').click(function(){
    document.querySelector('#form-produk').addEventListener('submit', function(e) {       
    var form = this;

    e.preventDefault(); // -- prevent form from submitting

    swal({
        title: "Anda Yakin ingin memposting Stock Opname ?",
        text: "Data akan diposting ke Stock & tidak bisa diedit lagi jika sudah diposting !",
        icon: "info",
        buttons: [
            'Batal',
            'Posting'
            ],
        dangerMode: true,
            }).then(function(isConfirm) {
            if (isConfirm) {
            swal({
                title: 'Confirm!',
                text: 'Klik OK untuk melanjutkan Posting !',
                icon: 'info'
                }).then(function() {
						$('#submit-control').html(' sedang posting... ');
						$('#submit-control').attr('disabled','disabled');
						$('.form-rekapopn').submit(); // -- submit form programmatically
					});
        } else {
			$('#submit-control').html(' Posting Stock Opname ');
			$('#submit-control').removeAttr('disabled');
            swal("Batal", "Stock Opname masih bisa diedit :)", "error");
        }
        })
    });    
});


/*---------------------------------------------------------------*/
function addItem(){

  $.ajax({
    url : "{{ route('stockopnamedetail.store') }}",
    type : "POST",
    data : $('.form-produk').serialize(),
    success : function(data)
		{
			if(data.msg=="error")
				{
				 swal("WARNING", " KODE ini sudah diinput !","error");
					$('#kode').val('').focus();
				}else{
					$('#kode').val('').focus();
					table.ajax.reload(function(){loadSummary(id_opn); }) ;         
				}
		},
			error : function(){
		//alert(" Tidak dapat menyimpan data ! ");
			swal("DANGER", " Detail Opname Gagal disimpan, HUB. IT !","error");
			}
			});
         return false;

}

function selectItem(kode){
	$('#kode').val(kode);
	$('#modal-produk').modal('hide');
	addItem();
	//inputForm(kode);
}

/* tampilkan form produk pricelist */
function showProduct(){
  $('#modal-produk').modal('show');
}

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "/sbo/stockopnamedetail/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Detail Opname');
       
       $('#id').val(data.id_opn);
       $('#nama').val(data.nama_brg);	   
       $('#noseri').val(data.no_seri);
	   $('#retail').val(data.harga_retail);
       $('#qty').val(data.opn_qty);       
	   
     },
     error : function(){
       alert("Tidak dapat menampilkan data Invoice !");
     }
   });
}

function printForm(){
     var id  = $('#idopn').val();
     alert(' print opname belum dibuat ');
}

function inputForm(id){
   save_method = "add";
   $('input[name=_method]').val('PATCH');
   $('#modal-form_input form')[0].reset();

   $.ajax({
     url : "/sbo/invoicedetail/"+id+"/caribrg",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form_input').modal('show');
       $('.modal-title').text('Input Detail Invoice');
       
       $('#idbrg').val(data.id);
	   $('#kdbrg_').val(data.kode_brg);
       $('#nama_').val(data.nama_brg);	   
       $('#gross_').val(data.harga_list);
     },
     error : function(){
       alert("Tidak dapat menampilkan data Invoice !");
     }
   });
}

/* modul delete tidak dipakai */
function deleteItem(id){
   if(confirm("  Apakah yakin data akan dihapus ?  ")){
     $.ajax({
       url : "/sbo/stockopnamedetail/"+id,
       type : "POST",
       data : {'_method' : 'DELETE', '_token' : $('meta[name=csrf-token]').attr('content')},
       success : function(data){
         table.ajax.reload(function(){
			loadSummary(id_opn);
          }); 
       },
       error : function(){
         alert("Tidak dapat menghapus data!");
       }
     });
   }
}

/* mreferesh perubahan total opn */

function loadSummary(id){
	
  $.ajax({
	   url : "/sbo/stockopnamedetail/loadsummary/"+id,
       type : "GET",
       dataType : 'JSON',
       success : function(data){
			$('#total-qty').text(data.totalqty);
			$('#total-rp').text(data.totalrp);
       },
       error : function(){
		 return false;
       }
  });
}


</script>

@endsection