@extends('layouts.app')


@section('title')
	
	<tr><td width="80">Terima Barang dari Cabang &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	&nbsp;&nbsp;&nbsp;
	<a onclick="window.history.back()" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
	<a onclick="window.location='{{ route('home') }}'" class="btn btn-primary"><i class="fa fa-home"></i> Home </a>
	<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	{{ tanggal_indonesia(date('Y-m-d'),false) }}</td>
	</tr>	
@endsection

@section('breadcrumb')
   @parent
   <li>terima barang</li>
@endsection

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Terima Barang dari Cabang</title>

	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script> 
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>

	<script type="text/javascript" src="public/adminLTE/dist/css/sweetalert.min.js"></script>

</head>


@section('content')   
<div class="row">
	<div class="col-sm-9">
		<div class="box">
			<div class="box-header"></div>
				<div class="box-body">  

<form method="post" id="form-terima">
{{ csrf_field() }}


<table class="table table-striped table-padding table-bordered" id="tblterima" style="background: #DCDCDC;" width="100%">
<thead>
   <tr class="tblheader">
   
 	  <th width="5%">No.</th>	  
      <th width="20%">No.Transfer</th>
	  <th width="20%">Tanggal</th>
      <th width="45%px">Dari</th>
      <th width="10%">Opsi</th> 	  
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>


@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
$(function(){
   table = $('.table').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "{{ route('transfer.dataterima') }}",
       "type" : "GET"
     }
   }); 
   
//submit
	  $(document).on("submit", function(e) {
      if(!e.isDefaultPrevented()){
		 
		 $('#submit-control').html(' Simpan Transfer ... ');
		 $('#submit-control').attr('disabled','disabled');
		  
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('transfer.store') }}";
         else url = "transfer/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form_create form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
				 if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#supl').focus().select();
				 }else{
					$('#modal-form_create').modal('hide');
					swal("SUCCESS", " Transfer baru berhasil dicreate ! ","success");
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');					
					table.ajax.reload();
				 }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
	 }
   });
});

function addForm(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form_create').modal('show');
   $('#modal-form_create form')[0].reset();            
   $('.modal-title').text('New Transfer');
}
   	 

function showData(id){
   save_method = "edit";

   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "invoice/"+id+"/lihat",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Data Detail');
       
       $('#id').val(data.id_plist);
	   $('#supp').val(data.sup_kode.concat(' - ',data.sup_nama));
  	   $('#nama').val(data.list_sku.concat(' - ',data.sku_name));
	   $('#box').val(data.prc_box).attr('readonly', true);
       $('#pcs').val(data.prc_pcs).attr('readonly', true);
       $('#gross').val(data.prc_hrggross).attr('readonly', true);
	   $('#disc1').val(data.prc_disc1).attr('readonly', true);
	   $('#disc2').val(data.prc_disc2).attr('readonly', true);
	   $('#disc3').val(data.prc_disc3).attr('readonly', true);
	   $('#ppn').val(data.prc_ppn).attr('readonly', true);
	   $('#status').val(data.prc_status).attr('readonly', true);
	   $('#expd').val(data.list_exp).attr('readonly', true);
	                 
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });   
   
}


</script>

@endsection
