<!-- page menampilkan form detail input invoice -->

@extends('layouts.myform')

<head>
  
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
   
  	<script type="text/javascript" src="/sbo/public/adminLTE/dist/css/sweetalert.min.js"></script>


</head>


@section('title')
 <table>

    <tr><td width="120"><b>Tujuan </b></td><td><b>{{ $cabang->cbg_kode.' - '.$cabang->cbg_name }}</b></td></tr>
	<tr><td width="120"><b>Tgl. Transfer</b></td><td><b>{{ tanggal_indonesia($m_trf->trf_tgl, false) }}</b></td></tr>
	<tr><td width="120"><b>No. Dokumen</b></td><td><b>{{ $m_trf->trf_no }}</b></td></tr>

</table>
 
@endsection

@section('breadcrumb')
   @parent
   <li>transfer detail</li>
@endsection

@section('content')     

<div class="row">
  <div class="col-xs-12">
    <div class="box">
   
<div class="box-body">

<form class="form form-horizontal form-produk" method="post" id="form-produk">
{{ csrf_field() }}
  
  <input type="hidden" name="idtrf" value="{{ $idtrf }}">
  
	    <a href="/sbo/transfer/{{ $idtrf }}/printform" class="btn btn-primary pull-right cetak"><i class="fa fa-print"> </i> Cetak Dokumen </a>
		<!--<button id="submit-control" type="submit" class="btn btn-success pull-right simpan"><i class="fa fa-floppy-o"> </i> Posting </button>-->
		<button type="button" class="btn btn-warning pull-right" onclick="window.history.back()"><i class="fa fa-times-circle"></i> Close </button> 

  <div class="form-group">
      <label for="kode" class="col-md-1 control-label" align="left">List Barang</label>
      <div class="col-md-3">
        <div class="input-group">
          <input id="kode" type="text" class="form-control" name="kode" autofocus required readonly="true">
          <span class="input-group-btn">
            <button onclick="showProduct()" type="button" class="btn btn-info"> + </button>
          </span>
        </div>
      </div>
  </div>

 </form>


<form class="form-detail">
{{ csrf_field() }} {{ method_field('PATCH') }}

<div class="row">
    
<!-- <div style="height:400px; overflow-y: scroll;">  -->

<table class="table table-fixed table-striped table-bordered tabel-trfdetail" id="trfdetail">

<thead>
              
   <tr class="tblheader">
      <th width="20">No</th>
      <th>Deskripsi</th>
	  <th>No.Seri</th>
      <th>Hg.Retail</th>
	  <th>QTY</th>
      <th width="50">Opsi</th>
   </tr>
</thead>


<tbody></tbody>
</table>

</div>

</form>

<!-- <div class="box-footer"> -->
          
	<div class="col-md-3">
		<form class="form form-horizontal form-rekaptrf" method="GET" action="/sbo/transfer/{{ $idtrf }}/update">
			{{ csrf_field() }}
			<input type="hidden" name="idtrf" value="{{ $idtrf }}">
		</form>
	</div>          

<!-- </div> -->

                </div>
            </div>
        </div>
    </div>
</div>


@include('transfer_detail.produk')
@include('transfer_detail.form')

@endsection

@section('script')

<script type="text/javascript">
var table, table1, save_method;

$(function(){
  $('.tabel-produk').DataTable();
  table = $('.tabel-trfdetail').DataTable({
      
     "scrollY": '58vh',
     "scrollCollapse": true,
     "paging": false,
     "processing" : true,
	 "dom" : 'bt',
     "ajax" : {
     "url" : "{{ route('transferdetail.data') }}",
     "type" : "GET"
	}


 }).on('draw.dt', function(){
   loadSummary();
 });


  $('.form-produk').on('submit', function(e){
      return false;
   });

   $('#kode').change(function(){
      addItem();
   });

});


/* simpan edit detail */
$('#modal-form form').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){
		 
         var id  = $('#id').val();
		 url = "/sbo/transferdetail/"+id+"/update";
         $.ajax({
           url : url,
           type : "GET",
           data : $('#modal-form form').serialize(),
           success : function(data){
             $('#modal-form').modal('hide');
             table.ajax.reload();
           },
           error : function(){
			 return false;
          }   
        });
        return false;
    }
    
}); 

///////////////////////////////////////

/* simpan data ke ms_invoice dan posting->stock , cetak  ---> purchase.update */

$('.simpan').click(function(){
    document.querySelector('#form-produk').addEventListener('submit', function(e) {       
    var form = this;

    e.preventDefault(); // -- prevent form from submitting

    swal({
        title: "Anda Yakin ingin memposting Invoice ?",
        text: "Data Invoice akan diposting ke Stock & tidak bisa diedit lagi jika sudah diposting !",
        icon: "info",
        buttons: [
            'Batal',
            'Simpan'
            ],
        dangerMode: true,
            }).then(function(isConfirm) {
            if (isConfirm) {
            swal({
                title: 'Confirm!',
                text: 'Klik OK untuk melanjutkan Posting !',
                icon: 'info'
                }).then(function() {
            $('.form-rekapinv').submit(); // -- submit form programmatically
        });
        } else {
            swal("Batal", "Invoice masih bisa diedit :)", "error");
        }
        })
    });    
});


/*---------------------------------------------------------------*/
function addItem(){

  $.ajax({
    url : "{{ route('transferdetail.store') }}",
    type : "POST",
    data : $('.form-produk').serialize(),
    success : function(data)
		{
			if(data.msg=="error")
				{
				 swal("WARNING", " KODE ini sudah ada di Invoice !","error");
					$('#kode').val('').focus();
				}else{
					$('#kode').val('').focus();
					table.ajax.reload(function(){loadSummary(); }) ;         
				}
		},
			error : function(){
		//alert(" Tidak dapat menyimpan data ! ");
			swal("DANGER", " Detail Invoice Gagal disimpan, HUB. IT !","error");
			}
			});
         return false;

}

function selectItem(kode){
	$('#kode').val(kode);
	$('#modal-produk').modal('hide');
	addItem();
	//inputForm(kode);
}

/* tampilkan form produk pricelist */
function showProduct(){
  $('#modal-produk').modal('show');
}

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "/sbo/transferdetail/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Detail Transfer');
       
       $('#id').val(data.id_trf);
	   $('#kdbrg').val(data.kode_brg);
       $('#nama').val(data.nama_brg);	   
       $('#noseri').val(data.no_seri);
	   $('#retail').val(data.trf_retail);
       $('#qty').val(data.trf_qty);       
	   
     },
     error : function(){
       alert("Tidak dapat menampilkan data Transfer !");
     }
   });
}

function inputForm(id){
   save_method = "add";
   $('input[name=_method]').val('PATCH');
   $('#modal-form_input form')[0].reset();

   $.ajax({
     url : "/sbo/transferdetail/"+id+"/caribrg",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form_input').modal('show');
       $('.modal-title').text('Input Detail Transfer');
       
       $('#idbrg').val(data.id);
	   $('#kdbrg_').val(data.kode_brg);
       $('#nama_').val(data.nama_brg);	   
       $('#gross_').val(data.harga_list);
     },
     error : function(){
       alert("Tidak dapat menampilkan data Invoice !");
     }
   });
}

/* modul delete tidak dipakai */
function deleteItem(id){
   if(confirm("  Apakah yakin data akan dihapus ?  ")){
     $.ajax({
       url : "/sbo/transferdetail/"+id,
       type : "POST",
       data : {'_method' : 'DELETE', '_token' : $('meta[name=csrf-token]').attr('content')},
       success : function(data){
         table.ajax.reload(function(){
			loadSummary();
          }); 
       },
       error : function(){
         alert("Tidak dapat menghapus data!");
       }
     });
   }
}

/* mreferesh perubahan total po */

function loadSummary(){
	
  $.ajax({
	   url : "/sbo/transferdetail/loadSummary/"+idtrf,
       type : "GET",
       dataType : 'JSON',
       success : function(data){
			$('#sub-total').text(data.subtotal);
       },
       error : function(){
         //alert("Tidak dapat menampilkan data total po !");
		 return false;
       }
  });
}
</script>

@endsection