@extends('layouts.app')


@section('title')
  Master User 
@endsection

@section('breadcrumb')
   @parent
   <li>user</li>
@endsection

@section('content')     
<div class="row">
  <div class="col-xs-12">
    <div class="card">

    <div class="card-block">        
    
      <div class="text-left">
        <a onclick="addForm()" class="btn btn-outline-success btn-sm"><i class="fa fa-plus-circle"></i> New User </a>&nbsp;
      </div>

<table class="table table-striped table-padding table-bordered table-responsive" id="tbl-user" width="100%">
<thead>
   <tr class="tblheader">
      <th width="5%">No</th>
      <th>Nama User</th>
      <th>Group</th>
      <th width="5%">Aksi</th>
   </tr>
</thead>
<tbody></tbody>
</table>

      </div>
    </div>
  </div>
</div>

@include('user.form')
@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
$(function(){
   table = $('.table').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "{{ route('user.data') }}",
       "type" : "GET"
     }
   }); 
   
   $('#modal-form form').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('user.store') }}";
         else url = "user/"+id;
         
          $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
             if(data.msg=="error"){
               	swal("WARNING", " Gagal menyimpan data !","error");
                $('#nama').focus().select();
             }else{
                $('#modal-form').modal('hide');
				swal("SUCCESS", " User berhasil disimpan ! ","success");
                table.ajax.reload();
             }   
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," Urer tidak dapat disimpan, harap hubungi IT !","error");			 
           }   
         });
		
//		$.ajax({
//           url : url,
//           type : "POST",
//           data : $('#modal-form form').serialize(),
//           success : function(data){
//             $('#modal-form').modal('hide');
//             table.ajax.reload();
//           },
//           error : function(){
//             alert("Tidak dapat menyimpan data!");
 //          }   
 //        });
         return false;
     }
   });
});

function addForm(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form').modal('show');
   $('#modal-form form')[0].reset();            
   $('#password, #password1').attr('required', true);
}

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "user/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
        $('#modal-form').modal('show');

        $('#id').val(data.id);
        $('#nama').val(data.username);
        $('#email').val(data.email);
        $('#password, #password1').removeAttr('required');
	      $('#group').val(data.group);
       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

function deleteData(id){
   if(confirm("Apakah yakin data akan dihapus?")){
     $.ajax({
       url : "user/"+id,
       type : "POST",
       data : {'_method' : 'DELETE', '_token' : $('meta[name=csrf-token]').attr('content')},
       success : function(data){
         table.ajax.reload();
       },
       error : function(){
         alert("Tidak dapat menghapus data!");
       }
     });
   }
}
</script>
@endsection