@extends('layouts.app')

@section('title')
  Edit Profil
@endsection

@section('breadcrumb')
   @parent
   <li>user</li>
   <li>edit profil</li>
@endsection

@section('content')     
<div class="row">
  <div class="col-xs-12">
    <div class="box">

 <form class="form form-horizontal" data-toggle="validator" method="post" enctype="multipart/form-data">
   {{ csrf_field() }} {{ method_field('PATCH') }}
   <div class="box-body">

  <div class="alert alert-info alert-dismissible" style="display:none">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
    <i class="icon fa fa-check"></i>
    Perubahan berhasil disimpan.
  </div>

<div class="row">
  <div class="container" style="padding:5px 50px;">

    <div class="col-md-4 col-sm-4 col-xs-12">
    <br>
      <div class="form-group">
        <label for="foto" >Foto Profil</label>
              <input id="foto" type="file" name="foto">
          <br><div class="tampil-foto"> <img src="{{ asset('public/images/'.Auth::user()->foto) }}" width="200"></div>
      </div>

    </div>

  <br><br>
    <div class="col-md-7 col-sm-7 col-xs-12">
      <div class="form-group">
        <label for="passwordlama">Password Lama</label>
          <input id="passwordlama" type="password" class="form-control" name="passwordlama">
          <span class="help-block with-errors"></span>
      </div>

      <div class="form-group">
        <label for="password">Password</label>
          <input id="password" type="password" class="form-control" name="password">
          <span class="help-block with-errors"></span>
      </div>

      <div class="form-group">
        <label for="password1">Ulang Password</label>
          <input id="password1" type="password" class="form-control" data-match="#password" name="password1">
          <span class="help-block with-errors"></span>
      </div>
      <br>
      <div class="form-group">
        <button type="button" onclick="window.location='{{ route('home') }}'" class="btn btn-warning" data-dismiss="modal"><i class="fa fa-times"></i> cancel</button>
        <button type="submit" class="btn btn-primary"><i class="fa fa-floppy-o"></i> save</button>
      </div>

    </div>
    </div>
  </div>

</form>
    </div>
  </div>
</div>
@endsection

@section('script')
<script type="text/javascript">
$(function(){
    $('#passwordlama').keyup(function(){
      if($(this).val() != "") $('#password, #password1').attr('required', true);
      else $('#password, #password1').attr('required', false);
    });

   $('.form').validator().on('submit', function(e){
      if(!e.isDefaultPrevented()){ 

         $.ajax({
           url : "{{ Auth::user()->id }}/change",
           type : "POST",
           data : new FormData($(".form")[0]),
           dataType: 'JSON',
           async: false,
           processData: false,
           contentType: false,
           success : function(data){
             if(data.msg == "error"){
               alert('Password lama salah!');
               $('#passwordlama').focus().select();
             }else{
               d = new Date();
               $('.alert').css('display', 'block').delay(2000).fadeOut();
               $('.tampil-foto img, .user-image, .user-header img').attr('src', data.url+'?'+d.getTime());
             }
           },
           error : function(){
             alert("Tidak dapat menyimpan data!");
           }   
         });
         return false;
     }
   });

});

</script>
@endsection