 <?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


/*-----------------------------------------------*/

Route::get('/home', function () {
   return redirect('dashboard');
});

Route::get('/', 'SettingController@welcome')->name('welcome');      /* ke halaman awal */
Route::get('setting/testprinter', 'SettingController@testprinter')->name('setting.testprinter');
Route::get('setting/tescetak', 'SettingController@tescetak')->name('setting.tescetak');


Route::get('/login', 'HomeController@index')->name('home');
Route::get('/logout', '\App\Http\Controllers\Auth\LoginController@logout')->name('logout');

Auth::routes();

Route::group(['middleware' => 'web'], function(){
   
   Route::get('user/profil', 'UserController@profil')->name('user.profil');
   Route::patch('user/{id}/change', 'UserController@changeProfil');

   Route::get('upload/upload', 'UploadController@upload')->name('upload.upload');
   Route::post('upload/proses', 'UploadController@proses_upload')->name('upload.proses');
   Route::resource('upload', 'UploadController');   

});

//Route::group(['middleware' => ['web', 'cekuser:1' ]], function(){

Route::group(['middleware' => ['auth']], function(){
    
    Route::get('dashboard', 'HomeController@index')->name('home');
    Route::get('home/userlogs', 'HomeController@userLogs')->name('homeuserlogs');

/*customer*/
    Route::get('customer/data', 'CustomerController@listData')->name('customer.data');
    Route::get('customer/index_customer', 'CustomerController@index_customer')->name('customer.index_customer');
    Route::get('customer/mastercustomer', 'CustomerController@masterCustomer')->name('customer.mastercustomer');
    Route::get('customer/jumlahcustomer', 'CustomerController@jumlahCustomer')->name('customer.jumlahcustomer');
    Route::get('customer/{tp}/printdata', 'CustomerController@printdata')->name('customer.printdata');
    Route::resource('customer', 'CustomerController');

/* referensi */
    Route::get('referensi/data', 'ReferensiController@listData')->name('referensi.data');
    Route::get('referensi/{id}/datakomisi', 'ReferensiController@datakomisi')->name('referensi.datakomisi');
    Route::get('referensi/{id}/daftartrans', 'ReferensiController@daftarTrans')->name('referensi.daftartrans');
    Route::post('referensi/simpankomisi', 'ReferensiController@simpanKomisi')->name('referensi.simpankomisi');    
    Route::get('referensi/{id}/report', 'ReferensiController@report')->name('referensi.report');
    Route::resource('referensi', 'ReferensiController');
    
/*pegawai*/
    Route::get('pegawai/data', 'PegawaiController@listData')->name('pegawai.data');
    Route::get('pegawai/{id}/tampilpegawai', 'PegawaiController@tampilpegawai')->name('pegawai.tampilpegawai');
    Route::resource('pegawai', 'PegawaiController');
    
/*gaji*/
    Route::get('gaji/data', 'GajiController@listData')->name('gaji.data');
    Route::get('gaji/indexproses', 'GajiController@indexproses')->name('gaji.indexproses');
    Route::post('gaji/prosesdata', 'GajiController@prosesData')->name('gaji.prosesdata');
    Route::get('gaji/{prd}/tampildata', 'GajiController@tampilData')->name('gaji.tampildata');
    Route::post('gaji/reportgaji', 'GajiController@reportGaji')->name('gaji.report');
    Route::get('gaji/{id}/editgaji', 'GajiController@editGaji')->name('gaji.editgaji');
    Route::get('gaji/{id}/simpaneditgaji', 'GajiController@simpanEditGaji')->name('gaji.simpaneditgaji');
    
    Route::resource('gaji', 'GajiController');
    

/*kasbon*/
    Route::get('kasbon/{id}/data', 'KasbonController@listData')->name('kasbon.data');
    Route::get('kasbon/{id}/datadetail', 'KasbonController@listDetail')->name('kasbon.datadetail');
    Route::get('kasbon/datakasbon', 'KasbonController@dataKasbon')->name('kasbon.datakasbon');

    Route::resource('kasbon', 'KasbonController');

/*category barang*/
    Route::get('category/data', 'CategoryController@listData')->name('category.data');
    Route::get('category/getdata', 'CategoryController@getData')->name('category.getdata');
    Route::get('category/{id}/edit', 'CategoryController@edit');
    Route::resource('category', 'CategoryController');   

    Route::get('supplier/data', 'SupplierController@listData')->name('supplier.data');
    Route::get('supplier/{id}/edit', 'SupplierController@edit')->name('supplier.edit');
    Route::get('supplier/{id}/listproduct', 'SupplierController@listProduct')->name('supplier.listproduct');
    Route::get('supplier/{id}/productsup', 'SupplierController@productSup')->name('supplier.productsup');
    Route::get('supplier/{id}/simpanproduct', 'SupplierController@simpanProduct')->name('supplier.simpanproduct');
    Route::get('supplier/pilihdata', 'SupplierController@pilihData')->name('supplier.pilihdata');
    Route::get('supplier/pricelist', 'SupplierController@pricelist')->name('supplier.pricelist');
    Route::get('supplier/{id}/listprice', 'SupplierController@listPrice')->name('supplier.listprice');
    Route::get('supplier/{id}/delproduct', 'SupplierController@delProduct')->name('supplier.delproduct');
    Route::get('supplier/{id}/editlist', 'SupplierController@editList')->name('supplier.editlist');
    Route::get('supplier/{id}/simpaneditlist', 'SupplierController@simpanEditList')->name('supplier.simpaneditlist');
    
    Route::get('supplier/import_data', 'SupplierController@import_data')->name('supplier.import_data');
    Route::post('supplier/importsupplier', 'SupplierController@importSupplier')->name('supplier.importsupplier');
    
    Route::resource('supplier', 'SupplierController'); 


///product
    Route::get('product/data', 'ProductController@listData')->name('product.data');	//yg ini tidak bisa proses serverside
    Route::get('product/getdata', 'ProductController@getData')->name('product.getdata');
    Route::get('product/pilihdata', 'ProductController@pilihData')->name('product.pilihdata');   
    Route::get('product/{id}/lihat', 'ProductController@show');		
    Route::get('product/{id}/uploadimg', 'ProductController@uploadImg')->name('product.uploadimg');
    Route::get('product/{id}/removeimage', 'ProductController@removeimage');
    Route::post('product/cetak', 'ProductController@printBarcode');
    Route::get('product/index_product', 'ProductController@index_product')->name('product.index_product');
    Route::get('product/masterproduct', 'ProductController@masterProduct')->name('product.masterproduct');
    Route::get('product/import_data', 'ProductController@import_data')->name('product.import_data');
    Route::post('product/importproduct', 'ProductController@importProduct')->name('product.importproduct');
    Route::get('product/printmaster', 'ProductController@printMaster')->name('product.printmaster');
    Route::resource('product', 'ProductController');
   

//stok keluar
    Route::get('keluar/datakeluar', 'KeluarController@datakeluar')->name('keluar.datakeluar');
    Route::get('keluar/{id}/edit', 'KeluarController@edit')->name('keluar.edit');
    Route::get('keluar/{id}/batal', 'KeluarController@batal')->name('keluar.batal');
    Route::get('keluar/{id}/datadetail', 'KeluarController@dataDetail')->name('keluar.datadetail');
    Route::get('keluar/{id}/listproduct', 'KeluarController@listProduct')->name('keluar.listproduct');
    Route::post('keluar/adddetail', 'KeluarController@addDetail')->name('keluar.adddetail');
    Route::get('keluar/{id}/editdetail', 'KeluarController@editDetail')->name('keluar.editdetail');
    Route::get('keluar/{id}/simpanedit', 'KeluarController@simpanEdit')->name('keluar.simpanedit');
    Route::get('keluar/{id}/printfaktur', 'KeluarController@printFaktur')->name('keluar.printfaktur');
    Route::post('keluar/posting', 'KeluarController@posting')->name('keluar.posting');
    Route::get('keluar/history_out', 'KeluarController@history_sale')->name('keluar.history');
    Route::get('keluar/{tg1}/{tg2}/datahistory', 'KeluarController@datahistory')->name('keluar.datahistory');


    Route::resource('keluar', 'KeluarController');
    

// project
    Route::get('project/dataproject', 'ProjectController@dataproject')->name('project.dataproject');
    Route::get('project/{id}/edit', 'ProjectController@edit')->name('project.edit');
    Route::resource('project', 'ProjectController');


    Route::get('rumah/{id}/datarumah', 'RumahController@datarumah')->name('rumah.datarumah');
    Route::get('rumah/{id}/listrumah', 'RumahController@listrumah')->name('rumah.listrumah');
    Route::post('rumah/simpanproject', 'RumahController@simpanproject')->name('rumah.simpanproject');
    Route::get('rumah/{id}/simpanedit', 'RumahController@simpanedit')->name('rumah.simpanedit');
    Route::get('rumah/{id}/daftarrumah', 'RumahController@daftarRumah')->name('rumah.daftarrumah');
    Route::get('rumah/{id}/daftarrumahsold', 'RumahController@daftarRumahSold')->name('rumah.daftarrumahsold');
    Route::get('rumah/{id}/inforumah', 'RumahController@infoRumah')->name('rumah.inforumah');
    Route::resource('rumah', 'RumahController');

// transaksi
    Route::get('transaksi/datatransaksi', 'TransaksiController@datatransaksi')->name('transaksi.datatransaksi');
    Route::get('transaksi/{id}/edit', 'TransaksiController@edit')->name('transaksi.edit');
    Route::get('transaksi/{id}/infotransaksi', 'TransaksiController@infotransaksi')->name('transaksi.infotransaksi');
    Route::get('transaksi/{id}/datacicilan', 'TransaksiController@datacicilan')->name('transkasi.datacicilan');
    Route::post('transaksi/simpancicilan', 'TransaksiController@simpanCicilan')->name('transaksi.simpancicilan');
    Route::get('transaksi/{id}/printkwt', 'TransaksiController@printkwt')->name('transaksi.printkwt');
    Route::get('transaksi/{id}/pengajuankpr', 'TransaksiController@pengajuanKPR')->name('transaksi.pengajuankpr');
    Route::get('transaksi/{id}/bataltransaksi', 'TransaksiController@batalTransaksi')->name('transaksi.bataltransaksi');
    Route::get('transaksi/testkwt', 'TransaksiController@testkwt')->name('transaksi.testkwt');
    Route::get('transaksi/bataltrx', 'TransaksiController@batalTrx')->name('transaksi.bataltrx');
    Route::get('transaksi/databatal', 'TransaksiController@dataBatal')->name('transaksi.databatal');
    Route::get('transaksi/{id}/datatermin', 'TransaksiController@datatermin')->name('transaksi.datatermin');
    Route::resource('transaksi', 'TransaksiController');

//termin
    Route::get('termin/{id}/data', 'TerminController@data')->name('termin.data');
    Route::get('termin/{id}/datarumah', 'TerminController@datarumah')->name('termin.datarumah');
    Route::resource('termin', 'TerminController');



//account
    Route::get('account/dataaccount', 'AccountController@dataAccount')->name('account.dataaccount');
    Route::get('account/{id}/edit', 'AccountController@edit')->name('account.edit');
    Route::resource('account', 'AccountController');
    
//hutang
    Route::get('hutang/{id}/data', 'HutangController@data')->name('hutang.data');
    Route::get('hutang/{id}/databayar', 'HutangController@databayar')->name('hutang.databayar');
    Route::post('hutang/simpanbayar', 'HutangController@simpanBayar')->name('hutang.simpanbayar');
    Route::get('hutang/{id}/editketerangan', 'HutangController@editKeterangan')->name('hutang.editketerangan');
    Route::get('hutang/{id}/simpanedit', 'HutangController@simpanEdit')->name('hutang.simpanedit');
    Route::resource('hutang', 'HutangController');    
    
//biaya
    Route::get('biaya/datakas', 'BiayaController@dataKas')->name('biaya.datakas');
    Route::get('biaya/{id}/databiaya', 'BiayaController@databiaya')->name('biaya.databiaya');
    Route::get('biaya/{id}/datamasuk', 'BiayaController@datamasuk')->name('biaya.datamasuk');
    Route::post('biaya/simpanbiaya', 'BiayaController@simpanBiaya')->name('biaya.simpanbiaya');
    Route::get('biaya/{id}/printrekap', 'BiayaController@printRekap')->name('biaya.printrekap');
    Route::post('biaya/kasmasuk', 'BiayaController@kasmasuk')->name('biaya.kasmasuk');
    Route::get('biaya/{id}/editbiaya', 'BiayaController@editbiaya')->name('biaya.editbiaya');
    Route::get('biaya/{id}/simpaneditbiaya', 'BiayaController@simpaneditbiaya')->name('biaya.simpaneditbiaya');
    Route::get('biaya/{id}/hitungsaldo', 'BiayaController@hitungsaldo')->name('biaya.hitungsaldo');
    Route::post('biaya/posting', 'BiayaController@posting');
    Route::get('biaya/import_data', 'BiayaController@import_data')->name('biaya.import_data');
    Route::post('biaya/importbiaya', 'BiayaController@importBiaya')->name('biaya.importproduct');
    
    Route::resource('biaya', 'BiayaController');
    
// pelunasan 
    Route::get('pelunasan/header', 'PelunasanController@getHeader')->name('pelunasan.header');
    Route::get('pelunasan/{gdg}/{tgl1}/{tgl2}/{tipe}/tampildata', 'PelunasanController@tampilData')->name('pelunasan.tampildata');
    Route::get('pelunasan/{id}/tampilheader', 'PelunasanController@tampilHeader')->name('pelunasan.tampilheader');
    Route::get('pelunasan/index_history', 'PelunasanController@index_history')->name('pelunasan.index_history');
    Route::get('pelunasan/{gdg}/{tgl1}/{tgl2}/history', 'PelunasanController@history')->name('pelunasan.history');
    Route::get('pelunasan/{id}/infopelunasan', 'PelunasanController@infoPelunasan')->name('pelunasan.infopelunasan');
    
    Route::resource('pelunasan', 'PelunasanController');
    
//po
    Route::get('po/index', 'POController@index_a')->name('po.index');
    Route::get('po/getheader', 'POController@getheader')->name('po.header');
    Route::get('po/{id}/edit',  'POController@edit')->name('po.editt');      
    Route::get('po/{id}/datadetail', 'POController@dataDetail')->name('po.datadetail');
    Route::get('po/{id}/detailedit', 'POController@DetailEdit')->name('po.detailedit');
    Route::get('po/{id}/loadsummary', 'POController@loadSummary')->name('po.loadsummary');
    Route::get('po/{id}/{tp}/listproduk', 'POController@listProduk')->name('po.listproduk');
    Route::get('po/{id}/{tp}/tampilproductlist', 'POController@tampilProductList')->name('po.tampilproductlist');    
    Route::post('po/adddetail', 'POController@addDetail')->name('po.adddetail');
    Route::get('po/{id}/editdetail', 'POController@editDetail')->name('po.editdetail');
    Route::get('po/{id}/simpanedit', 'POController@simpanEdit')->name('po.simpanedit');
    Route::get('po/{id}/simpaneditharga', 'POController@simpanEditHarga')->name('po.simpaneditharga');  
    Route::get('po/{id}/printpo', 'POController@printPO')->name('po.printpo');
    
    Route::resource('po', 'POController');


//invoice pembelian
    Route::get('invoice/index', 'InvoiceController@index_a')->name('invoice.index');
    Route::get('invoice/editharga', 'InvoiceController@editHarga')->name('invoice.editharga');
    Route::get('invoice/getheader', 'InvoiceController@getheader')->name('invoice.header');
    Route::get('invoice/headeredit', 'InvoiceController@headeredit')->name('invoice.headeredit');  
    Route::get('invoice/history', 'InvoiceController@history')->name('invoice.history');
    Route::get('invoice/history_header', 'InvoiceController@history_header')->name('invoice.history_header');
    Route::get('invoice/{sup}/{tglinv}/hitungjt', 'InvoiceController@hitungJT')->name('invoice.hitungjt');    
    Route::get('invoice/{id}/edit',  'InvoiceController@edit')->name('invoice.editt');      
    Route::get('invoice/{id}/datadetail', 'InvoiceController@dataDetail')->name('invoice.datadetail');
    Route::get('invoice/{id}/detailedit', 'InvoiceController@DetailEdit')->name('invoice.detailedit');
    Route::get('invoice/{id}/loadsummary', 'InvoiceController@loadSummary')->name('invoice.loadsummary');
    Route::get('invoice/{id}/{tp}/listproduk', 'InvoiceController@listProduk')->name('invoice.listproduk');
    Route::get('invoice/{id}/{tp}/tampilproductlist', 'InvoiceController@tampilProductList')->name('invoice.tampilproductlist');    
    Route::get('invoice/{id}/tampilkemasan', 'InvoiceController@tampilKemasan')->name('invoice.tampilkemasan');
    Route::post('invoice/adddetail', 'InvoiceController@addDetail')->name('invoice.adddetail');
    Route::get('invoice/{id}/editdetail', 'InvoiceController@editDetail')->name('invoice.editdetail');
    Route::get('invoice/{id}/simpanedit', 'InvoiceController@simpanEdit')->name('invoice.simpanedit');
    Route::get('invoice/{id}/simpaneditharga', 'InvoiceController@simpanEditHarga')->name('invoice.simpaneditharga');  
    Route::post('invoice/posting', 'InvoiceController@posting')->name('invoice.posting');
    Route::get('invoice/{id}/batal', 'InvoiceController@batal')->name('invoice.batal');

    Route::get('invoice/{id}/printfaktur', 'InvoiceController@printFaktur')->name('invoice.printfaktur');
    Route::get('invoice/{id}/printfaktur_matrix', 'InvoiceController@printFaktur_matrix')->name('invoice.printfaktur_matrix');    
    
    Route::resource('invoice', 'InvoiceController');


// pembayaran 
    Route::get('pembayaran/header', 'PembayaranController@getHeader')->name('pembayaran.header');
    Route::get('pembayaran/{sup}/tampildata', 'PembayaranController@tampilData')->name('pembayaran.tampildata');
    Route::get('pembayaran/{id}/tampilbayar', 'PembayaranController@tampilBayar')->name('pembayaran.tampilbayar');
    Route::get('pembayaran/index_history', 'PembayaranController@index_history')->name('pembayaran.index_history');
    Route::get('pembayaran/history', 'PembayaranController@history')->name('pembayaran.history');

    Route::resource('pembayaran', 'PembayaranController');

//mutasi stock
    Route::get('mutasi/index', 'MutasiController@index_a')->name('mutasi.index');
    Route::get('mutasi/getheader', 'MutasiController@getheader')->name('mutasi.header');  
    Route::get('mutasi/history', 'MutasiController@history')->name('mutasi.history');
    Route::get('mutasi/history_header', 'MutasiController@history_header')->name('mutasi.history_header');
    
    Route::get('mutasi/{id}/edit',  'MutasiController@edit')->name('mutasi.editt');      
    Route::get('mutasi/{id}/datadetail', 'MutasiController@dataDetail')->name('mutasi.datadetail');
    //Route::get('invoice/{id}/loadsummary', 'InvoiceController@loadSummary')->name('invoice.loadsummary');
    Route::get('mutasi/{id}/listproduk', 'MutasiController@listProduk')->name('mutasi.listproduk');
    Route::get('mutasi/{id}/listkemasan', 'MutasiController@listKemasan')->name('mutasi.listkemasan');
    Route::get('mutasi/{id}/tampilkemasan', 'MutasiController@tampilKemasan')->name('mutasi.tampilkemasan');
    Route::post('mutasi/adddetail', 'MutasiController@addDetail')->name('mutasi.adddetail');
    Route::get('mutasi/{id}/editdetail', 'MutasiController@editDetail')->name('mutasi.editdetail');
    Route::get('mutasi/{id}/simpanedit', 'MutasiController@simpanEdit')->name('mutasi.simpanedit');  
    Route::post('mutasi/posting', 'MutasiController@posting')->name('mutasi.posting');
    Route::get('mutasi/{id}/printfaktur', 'MutasiController@printFaktur')->name('mutasi.printfaktur');
    Route::get('mutasi/index_history', 'MutasiController@index_history')->name('mutasi.index_history');
    Route::get('mutasi/history', 'MutasiController@history')->name('mutasi.history');
    Route::get('mutasi/{id}/historydetail', 'MutasiController@historyDetail')->name('mutasi.historydetail');
    
    Route::resource('mutasi', 'MutasiController');

/* report */
    
    Route::get('report/index_jurnal', 'ReportController@index_jurnal')->name('report.index_jurnal');
    Route::post('report/jurnal', 'ReportController@jurnal')->name('report.jurnal');
    Route::get('report/index_sale', 'ReportController@index_sale')->name('report.index_sale');
    Route::get('report/index_kasmasuk', 'ReportController@index_kasmasuk')->name('report.index_kasmasuk');    
    Route::get('report/index_detail', 'ReportController@index_detail')->name('report.index_detail');
    Route::get('report/index_piutang', 'ReportCOntroller@index_piutang')->name('report.index_piutang');
    Route::get('report/{id}/infopembeli', 'ReportController@infoPembeli')->name('report.infopembeli');
    Route::get('report/index_pelunasan', 'ReportController@index_pelunasan')->name('report.index_pelunasan');
    Route::get('report/index_hutang', 'ReportController@index_hutang')->name('report.index_hutang');
    
    Route::post('report/viewreportsale', 'ReportController@viewreportSale')->name('report.viewreportsale');
    Route::post('report/viewreportpemasukan', 'ReportController@viewreportPemasukan')->name('report.viewreportpemasukan');
    Route::post('report/viewreportdetail', 'ReportController@viewreportDetail')->name('report.viewreportdetail');
    Route::post('report/viewreportpiutang', 'ReportController@viewreportPiutang')->name('report.viewreportpiutang');
    Route::post('report/viewreportpelunasan', 'ReportController@viewreportPelunasan')->name('report.viewreportpelunasan');
    Route::post('report/viewreporthutang', 'ReportController@viewreportHutang')->name('report.viewreporthutang');
    
    
    Route::post('report/exportsale', 'ReportController@exportSale')->name('report.exportsale');
    Route::post('report/exportkasmasuk', 'ReportController@exportKasMasuk')->name('report.exportkasmasuk');
    Route::get('report/index_pajak', 'ReportController@index_pajak')->name('report.index_pajak');
    Route::post('report/viewreportpajak', 'ReportController@viewreportPajak')->name('report.viewreportpajak');
    Route::post('report/exportpajak', 'ReportController@exportPajak')->name('report.exportpajak');
    Route::post('report/pajakcsv', 'ReportController@pajakCSV')->name('report.pajakcsv');
    
    Route::get('report/index_retur', 'ReportController@index_retur')->name('report.index_retur');
    Route::post('report/viewretur', 'ReportController@viewRetur')->name('report.viewretur');
    Route::post('report/exportretur', 'ReportController@exportRetur')->name('report.exportretur');    
    Route::get('report/pilihsupp', 'ReportController@pilihsupp')->name('report.pilihsupp');
    Route::get('report/{tg1}/{tg2}/exportpajak_xls', 'ReportController@exportPajak_XLS')->name('report.exportpajak_xls');
    
    Route::get('report/index_stock', 'ReportController@index_stock')->name('report.index_stock');
    Route::post('report/viewreportstock', 'ReportController@viewreportStock')->name('report.viewreportstock');
    Route::post('report/exportstock', 'ReportController@exportStock')->name('report.exportstock');

    Route::get('report/index_hutang', 'ReportController@index_hutang')->name('report.index_hutang');
    Route::post('report/viewreporthutang', 'ReportController@viewreportHutang')->name('report.viewreporthutang');
    Route::post('report/exporthutang', 'ReportController@exportHutang')->name('report.exporthutang');

    Route::get('report/index_piutang', 'ReportController@index_piutang')->name('report.index_piutang');
    Route::post('report/viewreportpiutang', 'ReportController@viewreportPiutang')->name('report.viewreportpiutang');
    Route::post('report/exportpiutang', 'ReportController@exportPiutang')->name('report.exportpiutang');
    
    Route::get('report/index_bonus', 'ReportController@index_bonus')->name('report.index_bonus');
    Route::post('report/viewreportbonus', 'ReportController@viewreportbonus')->name('report.viewreportbonus');
    Route::post('report/exportbonus', 'ReportController@exportbonus')->name('report.exportbonus');


    Route::resource('report', 'ReportController');

/* stock */
    Route::get('stock/{gdg}/listdata', 'StockController@listData')->name('stock.data');   
    Route::get('stock/{id}/tampilproduk', 'StockController@tampilProduk')->name('stock.tampilproduk');
    Route::get('stock/{id}/edit', 'StockController@edit');   
    Route::get('stock/{id}/lihat', 'StockController@show');
    Route::get('stock/{id}/stockrekap', 'StockController@stockRekap')->name('stock.stockrekap');
    Route::get('stock/{id}/outstanding', 'StockController@OutStanding')->name('stock.outstanding');   
    Route::get('stock/{id}/stockmasuk', 'StockController@stockMasuk')->name('stock.stockmasuk');   
    Route::get('stock/{id}/stockkeluar', 'StockController@stockKeluar')->name('stock.stockkeluar');
    Route::get('stock/{id}/stockretur', 'StockController@stockRetur')->name('stock.stockretur');      
    Route::get('stock/{id}/printform', 'StockController@printform')->name('stock.printform');
    Route::get('stock/{gdg}/{prd}/cekstock', 'StockController@cekStock')->name('stock.cekstock');
    Route::get('stock/{stk}/cekoutstanding', 'StockController@cekOutStanding')->name('stock.cekoutstanding');
    Route::get('stock/{id}/{tgl1}/{tgl2}/kartustock', 'StockController@kartuStock')->name('stock.kartustock');
    Route::post('stock/{gdg}/reportstock', 'StockController@reportStock')->name('stock.reportstock');
    Route::get('stock/{gdg}/reconsile', 'StockController@reconsile')->name('stock.reconsile');
    Route::get('stock/{id}/tampilstock', 'StockController@tampilStock')->name('stock.tampilstock');
    Route::post('stock/simpanadjust', 'StockController@simpanAdjust')->name('stock.simpanadjust');
    Route::get('stock/historyadjust','StockController@historyAdjust')->name('stock.historyadjust');
    Route::get('stock/dataadjust', 'StockController@dataAdjust')->name('stock.dataadjuts');
    
    Route::resource('stock', 'StockController');
    
    
//saleretail
    Route::get('saleretail/index', 'SaleRetailController@index')->name('saleretail.index');
    Route::resource('saleretail', 'SaleRetailController');


    Route::get('gudang/data', 'GudangController@listData')->name('gudang.data');
    Route::resource('gudang', 'GudangController');
   
//dropdown
    Route::get('dropdown/merkAjax/{id}', 'DropdownController@merkAjax')->name('dropdown.getdata');
    Route::resource('dropdown', 'DropdownController');   


// stock opname
   Route::get('stockopname/index', 'StockOpnameController@index')->name('stockopname.index');
   Route::get('stockopname/history', 'StockOpnameController@history')->name('StockOpname.history');
   Route::get('stockopname/getdata', 'StockOpnameController@getData')->name('StockOpname.getdata');
   Route::get('stockopname/getheader', 'StockOpnameController@getheader')->name('stockopname.header');
   Route::get('stockopname/history_header', 'StockOpnameController@history_header')->name('stockopname.history_header');
   Route::get('stockopname/{id}/edit',  'StockOpnameController@edit')->name('stockopname.edit');  
   Route::get('stockopname/{id}/datadetail', 'StockOpnameController@datadetail')->name('stockopname.datadetail');
   Route::get('stockopname/{id}/listkemasan', 'StockOpnameController@listKemasan')->name('stockopname.listkemasan');
   Route::get('stockopname/{id}/tampilkemasan', 'StockOpnameController@tampilKemasan')->name('stockopname.tampilkemasan');
   Route::post('stockopname/adddetail', 'StockOpnameController@addDetail')->name('stockopname.adddetail');
   Route::get('stockopname/{id}/editdetail', 'StockOpnameController@editDetail')->name('stockopname.editdetail');
   Route::get('stockopname/{id}/simpanedit', 'StockOpnameController@simpanEdit')->name('stockopname.simpanedit');
   Route::get('stockopname/{id}/printfaktur', 'StockOpnameController@printFaktur')->name('stockopname.printfaktur');
   Route::post('stockopname/posting', 'StockOpnameController@posting')->name('stockopname.posting');
   
   Route::resource('stockopname', 'StockOpnameController');


//transfer
   Route::get('transfer/index', 'TransferController@index_a')->name('transfer.index');
   Route::get('transfer/history', 'TransferController@history')->name('transfer.history');
   Route::get('transfer/getdata', 'TransferController@getData')->name('transfer.getdata');
   Route::get('transfer/getheader', 'TransferController@getheader')->name('transfer.header');
   Route::get('transfer/history_header', 'TransferController@history_header')->name('transfer.history_header');
   Route::get('transfer/{id}/input',  'TransferController@input')->name('transfer.input');  
   Route::get('transfer/{id}/detail_history', 'TransferController@detail_history')->name('transfer.detail_history');
   Route::get('transfer/{id}/tampil', 'TransferController@tampil')->name('transfer.tampil');
   Route::get('transfer/create', 'TransferController@create')->name('transfer.create');
   Route::get('transfer/pilihdata', 'TransferController@pilihData')->name('transfer.pilihdata');  
   Route::get('transfer/{id}/lihat', 'TransferController@show');
   Route::get('transfer/{id}/update', 'TransferController@update');	
   Route::get('transfer/{id}/printform', 'TransferController@printform')->name('transfer.cetak');
   Route::get('transfer/detail', 'TransferController@detail'); 
   Route::get('transfer/{id}/tambah', 'TransferController@tambah');
   Route::get('transfer/index_terima', 'TransferController@index_terima')->name('transfer.index_terima');
   Route::get('transfer/dataterima', 'TransferController@dataterima')->name('transfer.dataterima');
   Route::get('transfer/{id}/terima', 'TransferController@terima')->name('transfer.terima');
   Route::get('transfer/{id}/updatestock', 'TransferController@updatestock')->name('transfer.updatestock');
   Route::resource('transfer', 'TransferController');

//-----------------------------------------------------------------------------------//
   Route::get('user/data', 'UserController@listData')->name('user.data');
   Route::resource('user', 'UserController');

   Route::get('pembelian/data', 'PembelianController@listData')->name('pembelian.data');
   Route::get('pembelian/{id}/tambah', 'PembelianController@create');
   Route::get('pembelian/{id}/lihat', 'PembelianController@show');
   Route::resource('pembelian', 'PembelianController');   

   Route::get('pembelian_detail/{id}/data', 'PembelianDetailController@listData')->name('pembelian_detail.data');
   Route::get('pembelian_detail/loadform/{diskon}/{total}', 'PembelianDetailController@loadForm');
   Route::resource('pembelian_detail', 'PembelianDetailController');   


   Route::get('penjualan/data', 'PenjualanController@listData')->name('penjualan.data');
   Route::get('penjualan/{id}/lihat', 'PenjualanController@show');
   Route::resource('penjualan', 'PenjualanController');

   Route::get('laporan', 'LaporanController@index')->name('laporan.index');
   Route::post('laporan', 'LaporanController@refresh')->name('laporan.refresh');
   Route::get('laporan/data/{awal}/{akhir}', 'LaporanController@listData')->name('laporan.data'); 
   Route::get('laporan/pdf/{awal}/{akhir}', 'LaporanController@exportPDF');

   Route::get('setting/cekvalid', 'SettingController@cekvalid')->name('setting.cekvalid');
   Route::get('setting/perpanjang', 'SettingController@perpanjang')->name('setting.perpanjang');
   Route::get('setting/renew', 'SettingController@renew')->name('setting.renew');
   
   Route::resource('setting', 'SettingController');
   
});

